/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.commons.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.aksw.commons.util.strings.StringUtils;

public class IniUtils {
    public static Map<String, String> loadIniFile(File file) throws IOException {
        HashMap<String, String> config = new HashMap<String, String>();
        IniUtils.loadIniFile(file, config);
        return config;
    }

    public static void loadIniFile(File file, Map<String, String> out) throws IOException {
        IniUtils.loadIniFile(new BufferedReader(new FileReader(file)), out);
    }

    public static void loadIniFile(BufferedReader reader, Map<String, String> out) throws IOException {
        String line;
        String SOURCE = "source";
        Pattern pattern = Pattern.compile("\\s*([^=]*)\\s*=\\s*(.*)\\s*");
        ArrayList<String> loadFileNames = new ArrayList<String>();
        String tmp = "";
        while ((line = reader.readLine()) != null) {
            line.trim();
            if (line.startsWith(SOURCE)) {
                String fileName = line.substring(SOURCE.length()).trim();
                loadFileNames.add(fileName);
                continue;
            }
            Matcher m = pattern.matcher(line);
            if (!m.find()) continue;
            String key = m.group(1);
            String value = m.group(2);
            value = StringUtils.strip(value, "\"").trim();
            out.put(key, value);
        }
        for (String loadFileName : loadFileNames) {
            File file = new File(loadFileName);
            IniUtils.loadIniFile(file, out);
        }
    }
}

