/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.commons.sparql.api.core;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.query.Query;
import com.hp.hpl.jena.sparql.core.Var;
import com.hp.hpl.jena.sparql.engine.binding.Binding;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.aksw.commons.collections.PrefetchIterator;
import org.aksw.commons.sparql.api.core.QueryExecutionFactory;
import org.aksw.commons.sparql.api.core.QueryExecutionStreaming;
import org.aksw.commons.sparql.api.core.ResultSetClosable;
import org.aksw.commons.sparql.api.util.CannedQueryUtils;

public class Describer
extends PrefetchIterator<Triple> {
    private Iterator<Node> openNodes;
    private Collection<Var> resultVars;
    private ResultSetClosable rs;
    private Binding currentBinding = null;
    private Iterator<Var> currentVar = null;
    private QueryExecutionFactory qef;
    private QueryExecutionStreaming currentQe = null;

    public Describer(Iterator<Node> openNodes, ResultSetClosable rs, Collection<Var> resultVars, QueryExecutionFactory qef) {
        this.openNodes = openNodes;
        this.resultVars = resultVars;
        this.rs = rs;
        this.qef = qef;
    }

    public static Describer create(List<Node> resultUris, List<String> resultVars, ResultSetClosable rs, QueryExecutionFactory qef) {
        HashSet<Var> vars = null;
        if (rs != null) {
            if (!rs.hasNext()) {
                rs = null;
                resultVars = null;
            } else {
                vars = new HashSet<Var>();
                for (String var : resultVars) {
                    vars.add(Var.alloc((String)var));
                }
            }
        }
        Iterator<Node> it = resultUris == null ? null : resultUris.iterator();
        Describer result = new Describer(it, rs, vars, qef);
        return result;
    }

    public Iterator<Triple> describeNodeStreaming(Node node) {
        Query query = CannedQueryUtils.constructBySubject(node);
        QueryExecutionStreaming qe = this.qef.createQueryExecution(query);
        return qe.execConstructStreaming();
    }

    protected Iterator<Triple> prefetch() throws Exception {
        HashSet<Node> batch = new HashSet<Node>();
        int n = 10;
        while (this.openNodes != null && this.openNodes.hasNext() && batch.size() < n) {
            Node node = this.openNodes.next();
            batch.add(node);
        }
        while (batch.size() < n && this.rs != null) {
            Var var;
            Node node;
            if (this.currentVar == null || !this.currentVar.hasNext()) {
                if (!this.rs.hasNext()) break;
                this.currentBinding = this.rs.nextBinding();
                this.currentVar = this.resultVars.iterator();
            }
            if ((node = this.currentBinding.get(var = this.currentVar.next())) == null || !node.isURI()) continue;
            batch.add(node);
        }
        if (batch.isEmpty()) {
            this.currentQe = null;
            return null;
        }
        Query q = CannedQueryUtils.constructBySubjects(batch);
        this.currentQe = this.qef.createQueryExecution(q);
        Iterator<Triple> result = this.currentQe.execConstructStreaming();
        return result;
    }

    public void close() {
        if (this.rs != null) {
            this.rs.close();
        }
        if (this.currentQe != null) {
            this.currentQe.close();
        }
    }
}

