/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.commons.sparql;

import java.util.HashMap;
import java.util.Map;

public class SPARQLEndpoints {
    public static final String DBPEDIA = "http://dbpedia.org/sparql";
    public static final String DBPEDIA_LIVE = "http://live.dbpedia.org/sparql";
    public static final String LINKEDGEODATA = "http://linkedgeodata.org/sparql";
    public static final String LINKEDGEODATA_LIVE = "http://live.linkedgeodata.org/sparql";
    public static final String LINKEDMDB = "http://data.linkedmdb.org/sparql";
    public static final String FACTBOOK = "http://www4.wiwiss.fu-berlin.de/factbook/sparql";
    private static Map<String, String> endpointToPrefixMap = null;
    private static final String[][] endpointToPrefix = new String[][]{{"http://dbpedia.org/sparql", "http://dbpedia.org/resource/"}, {"http://linkedgeodata.org/sparql", "http://linkedgeodata.org/triplify/"}, {"http://data.linkedmdb.org/sparql", "http://data.linkedmdb.org/resource/film/"}};

    public static String endpointName(String endpoint) {
        if (endpoint.startsWith("http://")) {
            return endpoint.substring("http://".length()).replace("/sparql", "");
        }
        return "unknown" + endpoint != null ? " (" + endpoint + ")" : "";
    }

    private static void initMap() {
        endpointToPrefixMap = new HashMap<String, String>();
        for (String[] row : endpointToPrefix) {
            endpointToPrefixMap.put(row[0], row[1]);
        }
    }

    public static String prefix(String endpoint) {
        if (endpointToPrefixMap == null) {
            SPARQLEndpoints.initMap();
        }
        return endpointToPrefixMap.get(endpoint);
    }
}

