/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.commons.sparql.api.cache.extra;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.aksw.commons.sparql.api.cache.core.QueryString;
import org.aksw.commons.sparql.api.cache.extra.SqlDao;
import org.aksw.commons.util.jdbc.SqlUtils;
import org.slf4j.LoggerFactory;

public class SqlDaoBase
implements SqlDao {
    protected Connection conn;
    protected Map<Object, PreparedStatement> queryToStmt = new HashMap<Object, PreparedStatement>();
    protected Map<Object, String> idToQuery = new HashMap<Object, String>();

    protected SqlDaoBase() {
    }

    protected SqlDaoBase(Collection<? extends QueryString> queries) {
        for (QueryString queryString : queries) {
            this.idToQuery.put(queryString, queryString.getQueryString());
        }
    }

    protected void setPreparedStatement(Object id, String query) {
        LoggerFactory.getLogger(this.getClass()).trace("Preparing statement [" + id + "]: " + query);
        this.idToQuery.put(id, query);
    }

    private void close() throws SQLException {
        for (PreparedStatement item : this.queryToStmt.values()) {
            if (item == null) continue;
            item.close();
        }
        this.queryToStmt.clear();
    }

    @Override
    public void setConnection(Connection conn) throws SQLException {
        this.close();
        for (Map.Entry<Object, String> entry : this.idToQuery.entrySet()) {
            PreparedStatement stmt = conn.prepareStatement(entry.getValue());
            this.queryToStmt.put(entry.getKey(), stmt);
        }
        this.conn = conn;
    }

    private PreparedStatement getPreparedStatement(Object id) {
        PreparedStatement stmt = this.queryToStmt.get(id);
        if (stmt == null) {
            throw new RuntimeException("No such query with id " + id);
        }
        return stmt;
    }

    public <T> T execute(Object id, Class<T> clazz, Object ... args) throws SQLException {
        PreparedStatement stmt = this.getPreparedStatement(id);
        Object result = SqlUtils.execute((PreparedStatement)stmt, clazz, (Object[])args);
        return (T)result;
    }

    public <T> List<T> executeList(Object id, Class<T> clazz, Object ... args) throws SQLException {
        PreparedStatement stmt = this.getPreparedStatement(id);
        List result = SqlUtils.executeList((PreparedStatement)stmt, clazz, (Object[])args);
        return result;
    }

    public ResultSet executeQuery(Object id, Object ... args) throws SQLException {
        PreparedStatement stmt = this.getPreparedStatement(id);
        return SqlUtils.execute((PreparedStatement)stmt, (Object[])args);
    }

    @Override
    public Connection getConnection() {
        return this.conn;
    }
}

