/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.commons.sparql.api.cache.extra;

import java.io.InputStream;
import java.sql.Blob;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.Arrays;
import java.util.GregorianCalendar;
import java.util.Iterator;
import org.aksw.commons.collections.SinglePrefetchIterator;
import org.aksw.commons.sparql.api.cache.core.QueryString;
import org.aksw.commons.sparql.api.cache.extra.CacheCore;
import org.aksw.commons.sparql.api.cache.extra.CacheCoreEx;
import org.aksw.commons.sparql.api.cache.extra.CacheCoreExCompressor;
import org.aksw.commons.sparql.api.cache.extra.CacheEntry;
import org.aksw.commons.sparql.api.cache.extra.CacheEntryBase;
import org.aksw.commons.sparql.api.cache.extra.CacheEntryH2;
import org.aksw.commons.sparql.api.cache.extra.InputStreamProviderResultSetBlob;
import org.aksw.commons.sparql.api.cache.extra.SqlDaoBase;
import org.aksw.commons.util.strings.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CacheCoreH2
extends SqlDaoBase
implements CacheCore,
CacheCoreEx {
    private static final Logger logger = LoggerFactory.getLogger(CacheCoreH2.class);
    private boolean validateHash = true;
    private String defaultService = "";
    private String databaseDirectory = "cache";
    private String databaseName = "extraction";
    private boolean autoServerMode = true;
    private long lifespan = 86400000L;
    private Connection conn;

    @Override
    public CacheEntry lookup(String queryString) {
        return this.lookup(this.defaultService, queryString);
    }

    @Override
    public void write(String queryString, InputStream in) {
        this.write(this.defaultService, queryString, in);
    }

    public static CacheCoreH2 create(String dbName) throws ClassNotFoundException, SQLException {
        return CacheCoreH2.create(true, "cache/sparql", dbName, 86400000L);
    }

    public static CacheCoreH2 create(String dbName, long lifespan) throws ClassNotFoundException, SQLException {
        return CacheCoreH2.create(true, "cache/sparql", dbName, lifespan);
    }

    public static CacheCoreH2 create(boolean autoServerMode, String dbDir, String dbName, long lifespan) throws ClassNotFoundException, SQLException {
        return (CacheCoreH2)CacheCoreH2.create(autoServerMode, dbDir, dbName, lifespan, false);
    }

    public static CacheCoreEx create(boolean autoServerMode, String dbDir, String dbName, long lifespan, boolean useCompression) throws ClassNotFoundException, SQLException {
        Class.forName("org.h2.Driver");
        String jdbcString = "";
        if (autoServerMode) {
            jdbcString = ";AUTO_SERVER=TRUE";
        }
        Connection conn = DriverManager.getConnection("jdbc:h2:" + dbDir + "/" + dbName + jdbcString, "sa", "");
        Statement stmt = conn.createStatement();
        CacheCoreH2 tmp = new CacheCoreH2(conn, lifespan);
        return useCompression ? new CacheCoreExCompressor(tmp) : tmp;
    }

    public static CacheCoreEx create(String dbName, long lifespan, boolean useCompression) throws ClassNotFoundException, SQLException {
        return CacheCoreH2.create(true, "cache/sparql", dbName, lifespan, useCompression);
    }

    public CacheCoreH2(Connection conn, long lifespan) throws SQLException {
        super(Arrays.asList(Query.values()));
        try {
            conn.createStatement().executeUpdate(Query.CREATE.getQueryString());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.setConnection(conn);
        this.lifespan = lifespan;
    }

    public Iterator<CacheEntryH2> iterator() throws SQLException {
        final ResultSet rs = this.executeQuery(Query.DUMP, new Object[0]);
        return new SinglePrefetchIterator<CacheEntryH2>(){

            protected CacheEntryH2 prefetch() throws Exception {
                if (!rs.next()) {
                    return null;
                }
                byte[] rawQueryHash = rs.getBytes("query_hash");
                String queryHash = StringUtils.bytesToHexString((byte[])rawQueryHash);
                String queryString = rs.getString("query_string");
                Timestamp timestamp = rs.getTimestamp("time");
                Blob data = rs.getBlob("data");
                return new CacheEntryH2(timestamp.getTime(), CacheCoreH2.this.lifespan, new InputStreamProviderResultSetBlob(rs, data), queryString, queryHash);
            }

            public void close() {
                try {
                    rs.close();
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        };
    }

    @Override
    public synchronized CacheEntry lookup(String service, String queryString) {
        try {
            return this._lookup(service, queryString);
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CacheEntry _lookup(String service, String queryString) throws SQLException {
        ResultSet rs;
        block5: {
            Blob data;
            Timestamp timestamp;
            block6: {
                String cachedQueryString;
                String md5 = StringUtils.md5Hash((String)this.createHashRoot(service, queryString));
                rs = this.executeQuery(Query.LOOKUP, md5);
                if (!rs.next()) break block5;
                timestamp = rs.getTimestamp("time");
                data = rs.getBlob("data");
                if (!this.validateHash || (cachedQueryString = rs.getString("query_string")).equals(queryString)) break block6;
                logger.error("HASH-CLASH:\nService: " + service + "\nNew QueryString: " + queryString + "\nOld QueryString: " + cachedQueryString);
                CacheEntry cacheEntry = null;
                return cacheEntry;
            }
            CacheEntryBase cacheEntryBase = new CacheEntryBase(timestamp.getTime(), this.lifespan, new InputStreamProviderResultSetBlob(rs, data));
            return cacheEntryBase;
        }
        if (rs.next()) {
            logger.warn("Multiple cache hits found, just one expected.");
        }
        return null;
    }

    @Override
    public synchronized void write(String service, String queryString, InputStream in) {
        try {
            this._write(service, queryString, in);
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _write(String service, String queryString, InputStream in) throws SQLException {
        String md5 = StringUtils.md5Hash((String)this.createHashRoot(service, queryString));
        Timestamp timestamp = new Timestamp(new GregorianCalendar().getTimeInMillis());
        ResultSet rs = null;
        try {
            rs = this.executeQuery(Query.LOOKUP, md5);
            if (rs != null && rs.next()) {
                this.execute(Query.UPDATE, null, in, timestamp, md5);
            } else {
                this.execute(Query.INSERT, null, md5, queryString, in, timestamp);
            }
        }
        finally {
            if (rs != null) {
                rs.close();
            }
        }
    }

    public String createHashRoot(String service, String queryString) {
        return service + queryString;
    }

    static enum Query implements QueryString
    {
        CREATE("CREATE TABLE IF NOT EXISTS query_cache(query_hash BINARY PRIMARY KEY, query_string VARCHAR(15000), data BLOB, time TIMESTAMP)"),
        LOOKUP("SELECT * FROM query_cache WHERE query_hash=? LIMIT 1"),
        INSERT("INSERT INTO query_cache VALUES(?,?,?,?)"),
        UPDATE("UPDATE query_cache SET data=?, time=? WHERE query_hash=?"),
        DUMP("SELECT * FROM query_cache");

        private String queryString;

        private Query(String queryString) {
            this.queryString = queryString;
        }

        @Override
        public String getQueryString() {
            return this.queryString;
        }
    }
}

