/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.commons.jena.util;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.query.Query;
import com.hp.hpl.jena.sparql.core.Quad;
import com.hp.hpl.jena.sparql.core.Var;
import com.hp.hpl.jena.sparql.engine.binding.Binding;
import com.hp.hpl.jena.sparql.syntax.Element;
import java.util.HashSet;
import java.util.Set;
import org.aksw.commons.jena.util.QuadUtils;

public class QueryUtils {
    public static Query elementToQuery(Element pattern, String resultVar) {
        if (pattern == null) {
            return null;
        }
        Query query = new Query();
        query.setQueryPattern(pattern);
        query.setQuerySelectType();
        if (resultVar == null) {
            query.setQueryResultStar(true);
        }
        query.setResultVars();
        if (resultVar != null) {
            query.getResultVars().add(resultVar);
        }
        return query;
    }

    public static Query elementToQuery(Element pattern) {
        return QueryUtils.elementToQuery(pattern, null);
    }

    public static Set<Quad> instanciate(Iterable<Quad> quads, Binding binding) {
        HashSet<Quad> result = new HashSet<Quad>();
        Node[] nodes = new Node[4];
        for (Quad quad : quads) {
            for (int i = 0; i < 4; ++i) {
                Node node = QuadUtils.getNode(quad, i);
                if (node.isVariable()) {
                    node = binding.get((Var)node);
                }
                if (node == null || i < 3 && node.isLiteral()) {
                    result.clear();
                    return result;
                }
                nodes[i] = node;
            }
            Quad inst = QuadUtils.create(nodes);
            result.add(inst);
        }
        return result;
    }
}

