/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.commons.sparql.api.cache.extra;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintWriter;
import org.aksw.commons.sparql.api.cache.extra.CacheCoreEx;
import org.aksw.commons.sparql.api.cache.extra.CacheEntry;
import org.aksw.commons.sparql.api.cache.extra.CacheEntryBase;
import org.aksw.commons.sparql.api.cache.extra.InputStreamProviderBZip2;
import org.apache.commons.compress.compressors.CompressorOutputStream;
import org.apache.commons.compress.compressors.CompressorStreamFactory;

public class CacheCoreExCompressor
implements CacheCoreEx {
    private CacheCoreEx decoratee;
    private final CompressorStreamFactory streamFactory = new CompressorStreamFactory();
    private String compression = "bzip2";

    public CacheCoreExCompressor(CacheCoreEx decoratee) {
        this.decoratee = decoratee;
    }

    public static CacheCoreExCompressor wrap(CacheCoreEx decoratee) {
        return new CacheCoreExCompressor(decoratee);
    }

    public CacheEntry wrap(CacheEntry raw) {
        return raw == null ? null : new CacheEntryBase(raw.getTimestamp(), raw.getLifespan(), new InputStreamProviderBZip2(raw.getInputStreamProvider(), this.streamFactory, this.compression));
    }

    @Override
    public CacheEntry lookup(String service, String queryString) {
        CacheEntry raw = this.decoratee.lookup(service, queryString);
        return this.wrap(raw);
    }

    @Override
    public void write(String service, String queryString, InputStream in) {
        try {
            this._write(service, queryString, in);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void _write(String service, String queryString, InputStream in) throws Exception {
        ByteArrayOutputStream tmp = new ByteArrayOutputStream();
        CompressorOutputStream out = this.streamFactory.createCompressorOutputStream(this.compression, (OutputStream)tmp);
        BufferedReader reader = new BufferedReader(new InputStreamReader(in));
        PrintWriter writer = new PrintWriter((OutputStream)out);
        byte[] buffer = new byte[1024];
        int n = 0;
        while (-1 != (n = in.read(buffer))) {
            out.write(buffer, 0, n);
        }
        out.flush();
        out.close();
        this.decoratee.write(service, queryString, new ByteArrayInputStream(tmp.toByteArray()));
    }

    public CacheCoreEx getDecoratee() {
        return this.decoratee;
    }
}

