/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.commons.jena.reader;

import com.hp.hpl.jena.datatypes.RDFDatatype;
import com.hp.hpl.jena.datatypes.TypeMapper;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.RDFErrorHandler;
import com.hp.hpl.jena.rdf.model.impl.RDFDefaultErrorHandler;
import com.hp.hpl.jena.shared.SyntaxError;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Hashtable;
import org.aksw.commons.collections.SinglePrefetchIterator;
import org.aksw.commons.jena.reader.IStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NTripleIterator
extends SinglePrefetchIterator<Triple> {
    static final Logger log = LoggerFactory.getLogger(NTripleIterator.class);
    private Model model = null;
    private Hashtable<String, Node> anons = new Hashtable();
    private IStream in = null;
    private boolean inErr = false;
    private int errCount = 0;
    private static final int sbLength = 200;
    private RDFErrorHandler errorHandler;
    private String base;

    NTripleIterator() {
    }

    public NTripleIterator(InputStream in, String base, RDFErrorHandler errorHandler) {
        this(new InputStreamReader(in), base, errorHandler);
    }

    public NTripleIterator(Reader reader, String base, RDFErrorHandler errorHandler) {
        Object object = this.errorHandler = errorHandler == null ? new RDFDefaultErrorHandler() : errorHandler;
        if (!(reader instanceof BufferedReader)) {
            reader = new BufferedReader(reader);
        }
        this.base = base == null ? "" : base + ": ";
        this.in = new IStream(reader);
        if (this.errCount != 0) {
            throw new SyntaxError("unknown");
        }
    }

    public Triple prefetch() {
        Node predicate = null;
        while (!this.in.eof()) {
            while (!this.in.eof()) {
                this.inErr = false;
                this.skipWhiteSpace();
                if (this.in.eof()) {
                    return (Triple)this.finish();
                }
                Node subject = this.readResource();
                if (this.inErr) break;
                this.skipWhiteSpace();
                try {
                    predicate = this.readResource();
                }
                catch (Exception e1) {
                    this.errorHandler.fatalError(e1);
                }
                if (this.inErr) break;
                this.skipWhiteSpace();
                Node object = this.readNode();
                if (this.inErr) break;
                this.skipWhiteSpace();
                if (this.badEOF() || !this.expect(".")) break;
                try {
                    return new Triple(subject, predicate, object);
                }
                catch (Exception e2) {
                    this.errorHandler.fatalError(e2);
                }
            }
            if (!this.inErr) continue;
            ++this.errCount;
            while (!this.in.eof() && this.in.readChar() != '\n') {
            }
        }
        return (Triple)this.finish();
    }

    public Node readResource() {
        char inChar = this.in.readChar();
        if (this.badEOF()) {
            return null;
        }
        if (inChar == '_') {
            if (!this.expect(":")) {
                return null;
            }
            String name = this.readName();
            if (name == null) {
                this.syntaxError("expected bNode label");
                return null;
            }
            return this.lookupResource(name);
        }
        if (inChar == '<') {
            String uri = this.readURI();
            if (uri == null) {
                this.inErr = true;
                return null;
            }
            inChar = this.in.readChar();
            if (inChar != '>') {
                this.syntaxError("expected '>'");
                return null;
            }
            return Node.createURI((String)uri);
        }
        this.syntaxError("unexpected input");
        return null;
    }

    public Node readNode() {
        this.skipWhiteSpace();
        switch (this.in.nextChar()) {
            case '\"': {
                return this.readLiteral(false);
            }
            case 'x': {
                return this.readLiteral(true);
            }
            case '<': 
            case '_': {
                return this.readResource();
            }
        }
        this.syntaxError("unexpected input");
        return null;
    }

    /*
     * Enabled aggressive block sorting
     */
    protected Node readLiteral(boolean wellFormed) {
        StringBuffer lit = new StringBuffer(200);
        if (wellFormed) {
            this.deprecated("Use ^^rdf:XMLLiteral not xml\"literals\", .");
            if (!this.expect("xml")) {
                return null;
            }
        }
        if (!this.expect("\"")) {
            return null;
        }
        while (true) {
            int inChar;
            block22: {
                block23: {
                    char c;
                    block25: {
                        block24: {
                            inChar = this.in.readChar();
                            if (this.badEOF()) {
                                return null;
                            }
                            if (inChar != 92) break block23;
                            c = this.in.readChar();
                            if (this.in.eof()) {
                                this.inErr = true;
                                return null;
                            }
                            if (c != 'n') break block24;
                            inChar = 10;
                            break block22;
                        }
                        if (c != 'r') break block25;
                        inChar = 13;
                        break block22;
                    }
                    if (c == 't') {
                        inChar = 9;
                        break block22;
                    } else if (c == '\\' || c == '\"') {
                        inChar = c;
                        break block22;
                    } else {
                        if (c != 'u') {
                            this.syntaxError("illegal escape sequence '" + c + "'");
                            return null;
                        }
                        inChar = this.readUnicode4Escape();
                        if (this.inErr) {
                            return null;
                        }
                    }
                    break block22;
                }
                if (inChar == 34) {
                    String lang;
                    if ('@' == this.in.nextChar()) {
                        this.expect("@");
                        lang = this.readLang();
                    } else if ('-' == this.in.nextChar()) {
                        this.expect("-");
                        this.deprecated("Language tags should be introduced with @ not -.");
                        lang = this.readLang();
                    } else {
                        lang = "";
                    }
                    if (wellFormed) {
                        return Node.createLiteral((String)lit.toString(), null, (boolean)true);
                    }
                    if ('^' != this.in.nextChar()) {
                        return Node.createLiteral((String)lit.toString(), (String)lang, (boolean)false);
                    }
                    String datatypeURI = null;
                    if (!this.expect("^^<")) {
                        this.syntaxError("ill-formed datatype");
                        return null;
                    }
                    datatypeURI = this.readURI();
                    if (datatypeURI == null || !this.expect(">")) {
                        return null;
                    }
                    if (lang.length() > 0) {
                        this.deprecated("Language tags are not permitted on typed literals.");
                    }
                    return Node.createLiteral((String)lit.toString(), null, (RDFDatatype)TypeMapper.getInstance().getSafeTypeByName(datatypeURI));
                }
            }
            lit = lit.append((char)inChar);
        }
    }

    private char readUnicode4Escape() {
        char[] buf = new char[]{this.in.readChar(), this.in.readChar(), this.in.readChar(), this.in.readChar()};
        if (this.badEOF()) {
            return '\u0000';
        }
        try {
            return (char)Integer.parseInt(new String(buf), 16);
        }
        catch (NumberFormatException e) {
            this.syntaxError("bad unicode escape sequence");
            return '\u0000';
        }
    }

    private void deprecated(String s) {
        this.errorHandler.warning((Exception)new SyntaxError(this.syntaxErrorMessage("Deprecation warning", s, this.in.getLinepos(), this.in.getCharpos())));
    }

    private void syntaxError(String s) {
        this.errorHandler.error((Exception)new SyntaxError(this.syntaxErrorMessage("Syntax error", s, this.in.getLinepos(), this.in.getCharpos())));
        this.inErr = true;
    }

    private String readLang() {
        StringBuffer lang = new StringBuffer(15);
        char inChar;
        while (!Character.isWhitespace(inChar = this.in.nextChar()) && inChar != '.' && inChar != '^') {
            lang = lang.append(this.in.readChar());
        }
        return lang.toString();
    }

    private boolean badEOF() {
        if (this.in.eof()) {
            this.syntaxError("premature end of file");
        }
        return this.inErr;
    }

    protected String readURI() {
        StringBuffer uri = new StringBuffer(200);
        while (this.in.nextChar() != '>') {
            char inChar = this.in.readChar();
            if (inChar == '\\') {
                this.expect("u");
                inChar = this.readUnicode4Escape();
            }
            if (this.badEOF()) {
                return null;
            }
            uri = uri.append(inChar);
        }
        return uri.toString();
    }

    protected String readName() {
        char nextChar;
        StringBuffer name = new StringBuffer(200);
        while (Character.isLetterOrDigit(nextChar = this.in.nextChar()) || '-' == nextChar) {
            name = name.append(this.in.readChar());
            if (!this.badEOF()) continue;
            return null;
        }
        return name.toString();
    }

    private boolean expect(String str) {
        for (int i = 0; i < str.length(); ++i) {
            char want = str.charAt(i);
            if (this.badEOF()) {
                return false;
            }
            char inChar = this.in.readChar();
            if (inChar == want) continue;
            this.syntaxError("expected \"" + str + "\"");
            return false;
        }
        return true;
    }

    protected void skipWhiteSpace() {
        while (Character.isWhitespace(this.in.nextChar()) || this.in.nextChar() == '#') {
            char inChar = this.in.readChar();
            if (this.in.eof()) {
                return;
            }
            if (inChar != '#') continue;
            while (inChar != '\n') {
                inChar = this.in.readChar();
                if (!this.in.eof()) continue;
                return;
            }
        }
    }

    protected Node lookupResource(String name) {
        Node r = this.anons.get(name);
        if (r == null) {
            r = Node.createAnon();
            this.anons.put(name, r);
        }
        return r;
    }

    protected String syntaxErrorMessage(String sort, String msg, int linepos, int charpos) {
        return this.base + sort + " at line " + linepos + " position " + charpos + ": " + msg;
    }
}

