/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.commons.sparql.api.timeout;

import com.hp.hpl.jena.query.Query;
import com.hp.hpl.jena.query.QueryExecution;
import java.util.concurrent.TimeUnit;
import org.aksw.commons.sparql.api.core.QueryExecutionFactory;
import org.aksw.commons.sparql.api.core.QueryExecutionFactoryDecorator;
import org.aksw.commons.sparql.api.core.QueryExecutionStreaming;
import org.aksw.commons.sparql.api.core.Time;

public class QueryExecutionFactoryTimeout
extends QueryExecutionFactoryDecorator {
    private Time maxExecutionTime = null;
    private Time maxRetrievalTime = null;

    public static QueryExecutionFactoryTimeout decorate(QueryExecutionFactory decoratee, long timeout) {
        return new QueryExecutionFactoryTimeout(decoratee, timeout);
    }

    public QueryExecutionFactoryTimeout(QueryExecutionFactory decoratee) {
        super(decoratee);
    }

    public QueryExecutionFactoryTimeout(QueryExecutionFactory decoratee, long timeout) {
        this(decoratee, timeout, TimeUnit.MILLISECONDS);
    }

    public QueryExecutionFactoryTimeout(QueryExecutionFactory decoratee, long timeout, TimeUnit timeUnit) {
        super(decoratee);
        this.maxExecutionTime = new Time(timeout, timeUnit);
    }

    public QueryExecutionFactoryTimeout(QueryExecutionFactory decoratee, long timeout1, long timeout2) {
        this(decoratee, timeout1, TimeUnit.MILLISECONDS, timeout2, TimeUnit.MILLISECONDS);
    }

    public QueryExecutionFactoryTimeout(QueryExecutionFactory decoratee, long timeout1, TimeUnit timeUnit1, long timeout2, TimeUnit timeUnit2) {
        super(decoratee);
        this.maxExecutionTime = new Time(timeout1, timeUnit1);
        this.maxRetrievalTime = new Time(timeout2, timeUnit2);
    }

    private void configureWithTimeout(QueryExecution qe) {
        if (this.maxExecutionTime != null) {
            if (this.maxRetrievalTime != null) {
                qe.setTimeout(this.maxExecutionTime.getTime(), this.maxExecutionTime.getTimeUnit(), this.maxRetrievalTime.getTime(), this.maxRetrievalTime.getTimeUnit());
            } else {
                qe.setTimeout(this.maxExecutionTime.getTime(), this.maxExecutionTime.getTimeUnit());
            }
        }
    }

    @Override
    public QueryExecutionStreaming createQueryExecution(Query query) {
        QueryExecutionStreaming result = super.createQueryExecution(query);
        this.configureWithTimeout(result);
        return result;
    }

    @Override
    public QueryExecutionStreaming createQueryExecution(String queryString) {
        QueryExecutionStreaming result = super.createQueryExecution(queryString);
        this.configureWithTimeout(result);
        return result;
    }
}

