/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.commons.sparql.api.pagination.core;

import com.hp.hpl.jena.query.Query;
import com.hp.hpl.jena.query.ResultSet;
import com.hp.hpl.jena.sparql.engine.binding.Binding;
import com.hp.hpl.jena.sparql.engine.iterator.QueryIteratorResultSet;
import java.util.Iterator;
import org.aksw.commons.collections.PrefetchIterator;
import org.aksw.commons.sparql.api.core.QueryExecutionFactory;
import org.aksw.commons.sparql.api.core.QueryExecutionStreaming;
import org.aksw.commons.sparql.api.pagination.core.QueryExecutionIterated;
import org.openjena.atlas.lib.Closeable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResultSetPaginated
extends PrefetchIterator<Binding>
implements Closeable {
    private static Logger logger = LoggerFactory.getLogger(ResultSetPaginated.class);
    private QueryExecutionFactory service;
    private QueryExecutionIterated execution;
    private Iterator<Query> queryIterator;
    private boolean stopOnEmptyResult = true;
    private ResultSet currentResultSet = null;

    public ResultSetPaginated(QueryExecutionIterated execution, QueryExecutionFactory service, Iterator<Query> queryIterator, boolean stopOnEmptyResult) {
        this.execution = execution;
        this.service = service;
        this.queryIterator = queryIterator;
    }

    public ResultSet getCurrentResultSet() {
        return this.currentResultSet;
    }

    protected QueryIteratorResultSet prefetch() throws Exception {
        while (this.queryIterator.hasNext()) {
            Query query = this.queryIterator.next();
            if (query == null) {
                throw new RuntimeException("Null query encountered in iterator");
            }
            QueryExecutionStreaming qe = this.service.createQueryExecution(query);
            if (this.execution != null) {
                this.execution._setDecoratee(qe);
            }
            logger.trace("Executing: " + query);
            this.currentResultSet = qe.execSelect();
            if (!this.currentResultSet.hasNext()) {
                if (!this.stopOnEmptyResult) continue;
                return null;
            }
            return new QueryIteratorResultSet(this.currentResultSet);
        }
        return null;
    }

    public void close() {
        if (this.execution != null) {
            this.execution.close();
        }
    }
}

