/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.commons.sparql.api.pagination.core;

import com.hp.hpl.jena.query.Query;
import java.util.Iterator;
import org.aksw.commons.sparql.api.core.QueryExecutionFactory;
import org.aksw.commons.sparql.api.core.QueryExecutionFactoryBackQuery;
import org.aksw.commons.sparql.api.core.QueryExecutionStreaming;
import org.aksw.commons.sparql.api.http.QueryExecutionFactoryHttp;
import org.aksw.commons.sparql.api.pagination.core.PaginationUtils;
import org.aksw.commons.sparql.api.pagination.core.QueryExecutionIterated;
import org.aksw.commons.sparql.api.pagination.extra.PaginationQueryIterator;

public class QueryExecutionFactoryPaginated
extends QueryExecutionFactoryBackQuery {
    public static final long DEFAULT_PAGE_SIZE = 1000L;
    private QueryExecutionFactory decoratee;
    private long pageSize;

    public QueryExecutionFactoryPaginated(QueryExecutionFactory decoratee) {
        this(decoratee, PaginationUtils.adjustPageSize(decoratee, 1000L));
    }

    public QueryExecutionFactoryPaginated(QueryExecutionFactory decoratee, long pageSize) {
        this.pageSize = PaginationUtils.adjustPageSize(decoratee, pageSize);
        this.decoratee = decoratee;
    }

    @Override
    public QueryExecutionStreaming createQueryExecution(Query query) {
        PaginationQueryIterator queryIterator = new PaginationQueryIterator(query, this.pageSize);
        return new QueryExecutionIterated(this.decoratee, (Iterator<Query>)((Object)queryIterator));
    }

    @Override
    public String getId() {
        return this.decoratee.getId();
    }

    @Override
    public String getState() {
        return this.decoratee.getState();
    }

    public long getPageSize() {
        return this.pageSize;
    }

    public static void main(String[] args) {
        QueryExecutionFactoryHttp factory = new QueryExecutionFactoryHttp("http://linkedgeodata.org/sparql", "http://linkedgeodata.org");
        QueryExecutionFactoryPaginated fp = new QueryExecutionFactoryPaginated(factory, 10000L);
        System.out.println(fp.getPageSize());
    }
}

