/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.commons.sparql.api.dereference;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.query.Query;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import java.io.IOException;
import java.net.URISyntaxException;
import org.aksw.commons.sparql.api.core.QueryExecutionAdapter;
import org.aksw.commons.sparql.api.core.QueryExecutionBaseSelect;
import org.aksw.commons.sparql.api.dereference.Dereferencer;

public class QueryExecutionDereference
extends QueryExecutionAdapter {
    private Query query;
    private Dereferencer dereferencer;

    public QueryExecutionDereference(Query query, Dereferencer dereferencer) {
        this.query = query;
        this.dereferencer = dereferencer;
    }

    @Override
    public Model execDescribe() {
        try {
            return this._execDescribe(ModelFactory.createDefaultModel());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public Model execDescribe(Model model) {
        try {
            Model result = this._execDescribe(model);
            if (model != result) {
                result.add(model);
            }
            return result;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public Model _execDescribe(Model model) throws IOException, URISyntaxException {
        Node node = QueryExecutionBaseSelect.extractDescribeNode(this.query);
        return this.dereferencer.dereference(node.getURI());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        QueryExecutionDereference queryExecutionDereference = this;
        synchronized (queryExecutionDereference) {
            if (this.dereferencer != null) {
                try {
                    this.dereferencer.close();
                    this.dereferencer = null;
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        }
    }
}

