/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.commons.sparql.api.core;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.query.Query;
import com.hp.hpl.jena.query.ResultSet;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.Statement;
import com.hp.hpl.jena.sparql.syntax.Template;
import com.hp.hpl.jena.sparql.util.ModelUtils;
import com.hp.hpl.jena.update.UpdateRequest;
import java.util.Iterator;
import org.aksw.commons.collections.IClosable;
import org.aksw.commons.jena.util.QueryUtils;
import org.aksw.commons.sparql.api.core.ConstructIterator;
import org.aksw.commons.sparql.api.core.Describer;
import org.aksw.commons.sparql.api.core.IteratorWrapperClose;
import org.aksw.commons.sparql.api.core.QueryExecutionDecorator;
import org.aksw.commons.sparql.api.core.QueryExecutionFactory;
import org.aksw.commons.sparql.api.core.QueryExecutionStreaming;
import org.aksw.commons.sparql.api.core.ResultSetClosable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class QueryExecutionBaseSelect
extends QueryExecutionDecorator
implements QueryExecutionStreaming {
    private static final Logger logger = LoggerFactory.getLogger(QueryExecutionBaseSelect.class);
    private Query query;
    private QueryExecutionFactory subFactory;

    public static Model createModel(Iterator<Triple> it) {
        return QueryExecutionBaseSelect.createModel(ModelFactory.createDefaultModel(), it);
    }

    public static Model createModel(Model result, Iterator<Triple> it) {
        while (it.hasNext()) {
            Triple t = it.next();
            Statement stmt = ModelUtils.tripleToStatement((Model)result, (Triple)t);
            if (stmt == null) continue;
            result.add(stmt);
        }
        return result;
    }

    public QueryExecutionBaseSelect(Query query, QueryExecutionFactory subFactory) {
        super(null);
        this.query = query;
        this.subFactory = subFactory;
    }

    protected abstract QueryExecutionStreaming executeCoreSelectX(Query var1);

    protected ResultSetClosable executeCoreSelect(Query query) {
        if (this.decoratee != null) {
            throw new RuntimeException("A query is already running");
        }
        this.decoratee = this.executeCoreSelectX(query);
        if (this.decoratee == null) {
            throw new RuntimeException("Failed to obtain a QueryExecution for query: " + query);
        }
        ResultSet tmp = this.decoratee.execSelect();
        final QueryExecutionBaseSelect self = this;
        ResultSetClosable result = new ResultSetClosable(tmp, new IClosable(){

            public void close() {
                self.close();
            }
        });
        return result;
    }

    @Override
    public boolean execAsk() {
        if (!this.query.isAskType()) {
            throw new RuntimeException("ASK query expected. Got: [" + this.query.toString() + "]");
        }
        Query selectQuery = QueryUtils.elementToQuery(this.query.getQueryPattern());
        selectQuery.setLimit(1L);
        ResultSetClosable rs = this.executeCoreSelect(selectQuery);
        long rowCount = 0L;
        while (rs.hasNext()) {
            rs.next();
            ++rowCount;
        }
        if (rowCount > 1L) {
            logger.warn("Received " + rowCount + " rows for the query [" + this.query.toString() + "]");
        }
        return rowCount > 0L;
    }

    @Override
    public Model execDescribe() {
        Model model = ModelFactory.createDefaultModel();
        return this.execDescribe(model);
    }

    public static Node extractDescribeNode(Query query) {
        if (!query.isDescribeType()) {
            throw new RuntimeException("DESCRIBE query expected. Got: [" + query.toString() + "]");
        }
        if (query.getQueryPattern() != null || !query.getResultVars().isEmpty() || query.getResultURIs().size() > 1) {
            throw new RuntimeException("Sorry, DESCRIBE is only implemented for a single resource argument");
        }
        Node result = (Node)query.getResultURIs().get(0);
        return result;
    }

    @Override
    public Iterator<Triple> execDescribeStreaming() {
        ResultSetClosable rs = null;
        if (this.query.getQueryPattern() != null) {
            Query q = new Query();
            q.setQuerySelectType();
            q.setResultVars();
            for (String v : this.query.getResultVars()) {
                q.addResultVar(v);
            }
            q.setQueryPattern(this.query.getQueryPattern());
            rs = this.executeCoreSelect(q);
        }
        Describer tmp = Describer.create(this.query.getResultURIs(), this.query.getResultVars(), rs, this.subFactory);
        final QueryExecutionBaseSelect self = this;
        IteratorWrapperClose<Triple> result = new IteratorWrapperClose<Triple>((Iterator)((Object)tmp)){

            public void close() {
                self.close();
            }
        };
        return result;
    }

    @Override
    public Model execDescribe(Model result) {
        QueryExecutionBaseSelect.createModel(result, this.execDescribeStreaming());
        return result;
    }

    private Iterator<Triple> executeConstructStreaming(Query query) {
        if (!query.isConstructType()) {
            throw new RuntimeException("CONSTRUCT query expected. Got: [" + query.toString() + "]");
        }
        query.setQueryResultStar(true);
        ResultSetClosable rs = this.executeCoreSelect(query);
        Template template = query.getConstructTemplate();
        ConstructIterator result = new ConstructIterator(template, rs);
        return result;
    }

    private Model executeConstruct(Query query, Model result) {
        QueryExecutionBaseSelect.createModel(result, this.executeConstructStreaming(query));
        return result;
    }

    @Override
    public Model execConstruct(Model result) {
        return this.executeConstruct(this.query, result);
    }

    @Override
    public Model execConstruct() {
        Model result = ModelFactory.createDefaultModel();
        this.execConstruct(result);
        return result;
    }

    @Override
    public Iterator<Triple> execConstructStreaming() {
        return this.executeConstructStreaming(this.query);
    }

    @Override
    public ResultSet execSelect() {
        if (!this.query.isSelectType()) {
            throw new RuntimeException("SELECT query expected. Got: [" + this.query.toString() + "]");
        }
        return this.executeCoreSelect(this.query);
    }

    public void executeUpdate(UpdateRequest updateRequest) {
        throw new RuntimeException("Not implemented");
    }
}

