/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.commons.sparql.api.pagination.extra;

import com.hp.hpl.jena.query.Query;

public class PaginationState {
    private long nextOffset;
    private Long nextRemaining;
    private Query query;
    private long pageSize;

    public PaginationState(Query query, long pageSize) {
        this.query = query;
        this.pageSize = pageSize;
        this.nextOffset = query.getOffset() == Long.MIN_VALUE ? 0L : query.getOffset();
        this.nextRemaining = query.getLimit() == Long.MIN_VALUE ? null : Long.valueOf(query.getLimit());
    }

    public Query next() throws Exception {
        if (this.nextOffset == 0L) {
            this.query.setOffset(Long.MIN_VALUE);
        } else {
            this.query.setOffset(this.nextOffset);
        }
        if (this.nextRemaining == null) {
            this.query.setLimit(this.pageSize);
            this.nextOffset += this.pageSize;
        } else {
            long limit = Math.min(this.pageSize, this.nextRemaining);
            this.nextOffset += limit;
            this.nextRemaining = this.nextRemaining - limit;
            if (limit == 0L) {
                return null;
            }
            this.query.setLimit(limit);
        }
        return this.query;
    }
}

