/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.commons.sparql.api.http;

import com.google.common.base.Joiner;
import com.hp.hpl.jena.query.QueryExecution;
import com.hp.hpl.jena.sparql.engine.http.QueryEngineHTTP;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.aksw.commons.sparql.api.core.QueryExecutionFactoryBackString;

public class QueryExecutionFactoryHttp
extends QueryExecutionFactoryBackString {
    private String service;
    private List<String> defaultGraphs = new ArrayList<String>();

    public QueryExecutionFactoryHttp(String service, Collection<String> defaultGraphs) {
        this.service = service;
        this.defaultGraphs = new ArrayList<String>(defaultGraphs);
        Collections.sort(this.defaultGraphs);
    }

    @Override
    public String getId() {
        return this.service;
    }

    @Override
    public String getState() {
        return Joiner.on((String)"|").join(this.defaultGraphs);
    }

    @Override
    public QueryExecution createQueryExecution(String queryString) {
        QueryEngineHTTP engine = new QueryEngineHTTP(this.service, queryString);
        engine.setDefaultGraphURIs(this.defaultGraphs);
        return engine;
    }
}

