/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.commons.sparql.api.core;

import com.hp.hpl.jena.query.QuerySolution;
import com.hp.hpl.jena.query.ResultSet;
import com.hp.hpl.jena.sparql.engine.binding.Binding;
import org.aksw.commons.collections.IClosable;
import org.aksw.commons.sparql.api.core.ResultSetDecorator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResultSetClosing
extends ResultSetDecorator {
    private static final Logger logger = LoggerFactory.getLogger(ResultSetClosing.class);
    private IClosable closable;
    private boolean isClosed = false;

    public ResultSetClosing(ResultSet decoratee, IClosable closable) {
        super(decoratee);
        this.closable = closable;
        this.checkClose();
    }

    protected boolean checkClose() {
        if (!this.isClosed && !this.decoratee.hasNext()) {
            try {
                this.isClosed = true;
                this.closable.close();
            }
            catch (Exception e) {
                logger.error("Error closing an object supposedly underlying a Jena ResultSet", (Throwable)e);
            }
        }
        return this.isClosed;
    }

    @Override
    public boolean hasNext() {
        return !this.checkClose();
    }

    @Override
    public void remove() {
        super.remove();
        this.checkClose();
    }

    @Override
    public QuerySolution nextSolution() {
        QuerySolution result = super.nextSolution();
        this.checkClose();
        return result;
    }

    @Override
    public Binding nextBinding() {
        Binding result = super.nextBinding();
        this.checkClose();
        return result;
    }
}

