/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.commons.sparql.api.cache.extra;

import com.hp.hpl.jena.query.ResultSet;
import com.hp.hpl.jena.query.ResultSetFactory;
import com.hp.hpl.jena.rdf.model.Model;
import java.io.InputStream;
import java.sql.Clob;
import java.sql.SQLException;
import org.aksw.commons.sparql.api.cache.extra.CacheResourceBase;
import org.aksw.commons.sparql.api.cache.extra.ClosableCacheSql;
import org.aksw.commons.sparql.api.cache.extra.SqlUtils;
import org.aksw.commons.sparql.api.core.ResultSetClosing;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CacheResourceSql
extends CacheResourceBase {
    private static Logger logger = LoggerFactory.getLogger(CacheResourceSql.class);
    private java.sql.ResultSet rs;
    private Clob clob;

    public CacheResourceSql(long timestamp, long lifespan, java.sql.ResultSet rs, Clob clob) {
        super(timestamp, lifespan);
        this.rs = rs;
        this.clob = clob;
    }

    @Override
    public ResultSet asResultSet() {
        try {
            return this._asResultSet();
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    public ResultSet _asResultSet() throws SQLException {
        InputStream in = this.clob.getAsciiStream();
        return new ResultSetClosing(ResultSetFactory.fromXML((InputStream)in), new ClosableCacheSql(this, in));
    }

    @Override
    public Model asModel(Model result) {
        try {
            return this._asModel(result);
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    public Model _asModel(Model result) throws SQLException {
        InputStream in = this.clob.getAsciiStream();
        result.read(in, null, "N-TRIPLE");
        try {
            in.close();
        }
        catch (Exception e) {
            logger.warn("Error", (Throwable)e);
        }
        this.close();
        return result;
    }

    public void close() {
        SqlUtils.close(this.rs);
    }
}

