/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.commons.sparql.api.cache.extra;

import java.io.InputStream;
import java.io.InputStreamReader;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.Arrays;
import java.util.GregorianCalendar;
import org.aksw.commons.sparql.api.cache.core.QueryString;
import org.aksw.commons.sparql.api.cache.extra.CacheCore;
import org.aksw.commons.sparql.api.cache.extra.CacheResource;
import org.aksw.commons.sparql.api.cache.extra.CacheResourceSql;
import org.aksw.commons.sparql.api.cache.extra.SqlDaoBase;
import org.aksw.commons.sparql.api.cache.extra.SqlUtils;
import org.aksw.commons.util.strings.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CacheCoreH2
extends SqlDaoBase
implements CacheCore {
    private static final Logger logger = LoggerFactory.getLogger(CacheCoreH2.class);
    private String databaseDirectory = "cache";
    private String databaseName = "extraction";
    private boolean autoServerMode = true;
    private long lifespan = 86400000L;
    private Connection conn;

    public static CacheCoreH2 create(boolean autoServerMode, String dbDir, String dbName, long lifespan) throws ClassNotFoundException, SQLException {
        Class.forName("org.h2.Driver");
        String jdbcString = "";
        if (autoServerMode) {
            jdbcString = ";AUTO_SERVER=TRUE";
        }
        Connection conn = DriverManager.getConnection("jdbc:h2:" + dbDir + "/" + dbName + jdbcString, "sa", "");
        Statement stmt = conn.createStatement();
        return new CacheCoreH2(conn, lifespan);
    }

    public CacheCoreH2(Connection conn, long lifespan) throws SQLException {
        super(Arrays.asList(Query.values()));
        this.setConnection(conn);
        this.lifespan = lifespan;
    }

    @Override
    public CacheResource lookup(String queryString) {
        try {
            return this._lookup(queryString);
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CacheResource _lookup(String queryString) throws SQLException {
        String md5 = StringUtils.md5Hash((String)queryString);
        ResultSet rs = this.executeQuery(Query.LOOKUP, md5);
        try {
            if (rs.next()) {
                Timestamp timestamp = rs.getTimestamp("store_time");
                Clob data = rs.getClob("data");
                CacheResourceSql cacheResourceSql = new CacheResourceSql(timestamp.getTime(), this.lifespan, rs, data);
                return cacheResourceSql;
            }
            if (rs.next()) {
                logger.warn("Multiple cache hits found, just one expected.");
            }
        }
        finally {
            SqlUtils.close(rs);
        }
        return null;
    }

    @Override
    public void write(String queryString, InputStream in) {
        try {
            this._write(queryString, in);
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void _write(String queryString, InputStream in) throws SQLException {
        String md5 = StringUtils.md5Hash((String)queryString);
        Timestamp timestamp = new Timestamp(new GregorianCalendar().getTimeInMillis());
        InputStreamReader reader = new InputStreamReader(in);
        ResultSet rs = null;
        try {
            rs = this.executeQuery(Query.LOOKUP, md5);
            if (rs != null && rs.next()) {
                this.execute(Query.UPDATE, null, reader, timestamp, md5);
            } else {
                this.execute(Query.INSERT, null, md5, queryString, reader, timestamp);
            }
        }
        finally {
            if (rs != null) {
                rs.close();
            }
        }
    }

    static enum Query implements QueryString
    {
        CREATE("\"CREATE TABLE IF NOT EXISTS query_cache(query_hash BINARY PRIMARY KEY, query_string VARCHAR(20000), data CLOB, time TIMESTAMP)"),
        LOOKUP("SELECT * FROM query_cache WHERE query_hash=? LIMIT 1"),
        INSERT("INSERT INTO query_cache VALUES(?,?,?,?)"),
        UPDATE("UPDATE query_cache SET TRIPLES=?, STORE_TIME=? WHERE query_hash=?");

        private String queryString;

        private Query(String queryString) {
            this.queryString = queryString;
        }

        @Override
        public String getQueryString() {
            return this.queryString;
        }
    }
}

