/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.commons.sparql.api.cache.core;

import com.hp.hpl.jena.query.QueryExecution;
import com.hp.hpl.jena.query.ResultSet;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import org.aksw.commons.sparql.api.cache.extra.Cache;
import org.aksw.commons.sparql.api.cache.extra.CacheResource;
import org.aksw.commons.sparql.api.core.QueryExecutionDecorator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QueryExecutionCache
extends QueryExecutionDecorator {
    private static final Logger logger = LoggerFactory.getLogger(QueryExecutionCache.class);
    private Cache cache;
    private String queryString;

    public QueryExecutionCache(QueryExecution decoratee, String queryString, Cache cache) {
        super(decoratee);
        this.cache = cache;
    }

    public ResultSet doCacheResultSet() {
        CacheResource resource = this.cache.lookup(this.queryString);
        if (resource == null || resource.isOutdated()) {
            try {
                ResultSet rs = this.getDecoratee().execSelect();
            }
            catch (Exception e) {
                logger.warn("Error communicating with backend", (Throwable)e);
                if (resource != null) {
                    return resource.asResultSet();
                }
                throw new RuntimeException(e);
            }
        }
        return resource.asResultSet();
    }

    public Model doCacheModel(Model result) {
        CacheResource resource = this.cache.lookup(this.queryString);
        Model model = ModelFactory.createDefaultModel();
        if (resource == null || resource.isOutdated()) {
            try {
                model = this.getDecoratee().execConstruct();
            }
            catch (Exception e) {
                logger.warn("Error communicating with backend", (Throwable)e);
                if (resource != null) {
                    model = resource.asModel(model);
                    result.add(model);
                    return result;
                }
                throw new RuntimeException(e);
            }
        }
        return resource.asModel(result);
    }

    @Override
    public ResultSet execSelect() {
        return this.doCacheResultSet();
    }

    @Override
    public Model execConstruct() {
        return this.doCacheModel(ModelFactory.createDefaultModel());
    }

    @Override
    public Model execConstruct(Model model) {
        return this.doCacheModel(model);
    }

    @Override
    public Model execDescribe() {
        return super.execDescribe();
    }

    @Override
    public Model execDescribe(Model model) {
        return super.execDescribe(model);
    }

    @Override
    public boolean execAsk() {
        return super.execAsk();
    }
}

