package org.aksw.commons.sparql.api.pagination.core;

import com.hp.hpl.jena.query.QuerySolution;
import com.hp.hpl.jena.query.ResultSet;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.sparql.engine.binding.Binding;
import org.openjena.atlas.iterator.Iter;

import java.util.Iterator;
import java.util.List;

/**
 * @author Claus Stadler
 *         <p/>
 *         Date: 7/26/11
 *         Time: 11:56 PM
 */
public class ResultSetCombined
    implements ResultSet
{
    private Iterator<ResultSet> it;
    private ResultSet current = null;

    public ResultSetCombined(Iterator<ResultSet> it) {
        this.it = it;
    }

    private boolean checkCurrent() {
        if(current == null) {
            if(!it.hasNext()) {
                return false;
            }
            current = it.next();
        }
        return current.hasNext();
    }

    public QuerySolution next() {
        return checkCurrent() ? current.next() : null;
    }

    @Override
    public void remove() {
        //return current.remove();
    }

    public Binding nextBinding() {
        return checkCurrent() ? current.nextBinding() : null;
    }

    @Override
    public boolean hasNext() {
        return it.hasNext() || current != null && current.hasNext();
    }

    @Override
    public QuerySolution nextSolution() {
        return checkCurrent() ? current.nextSolution() : null;
    }

    @Override
    public int getRowNumber() {
        return 0;  //To change body of implemented methods use File | Settings | File Templates.
    }

    @Override
    public List<String> getResultVars() {
        return null;  //To change body of implemented methods use File | Settings | File Templates.
    }

    @Override
    public Model getResourceModel() {
        return checkCurrent() ? current.getResourceModel() : null;
    }


}
