/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.commons.sparql.core.decorator;

import com.hp.hpl.jena.query.ResultSet;
import com.hp.hpl.jena.query.ResultSetFactory;
import com.hp.hpl.jena.query.ResultSetFormatter;
import com.hp.hpl.jena.query.ResultSetRewindable;
import com.hp.hpl.jena.rdf.model.Model;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URLEncoder;
import java.security.MessageDigest;
import java.util.Set;
import org.aksw.commons.sparql.core.QueryCollection;
import org.aksw.commons.sparql.core.SparqlEndpoint;
import org.aksw.commons.sparql.core.SparqlEndpoint$class;
import org.aksw.commons.sparql.core.decorator.CachingSparqlEndpoint$;
import org.aksw.commons.sparql.core.decorator.ClosingResultSet;
import org.aksw.commons.sparql.core.impl.HttpSparqlEndpoint;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Array$;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.ScalaObject;
import scala.Some;
import scala.collection.Iterable$;
import scala.collection.IterableLike;
import scala.collection.Seq;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassManifest;
import scala.reflect.ClassManifest$;
import scala.reflect.Manifest$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ScalaSignature(bytes="\u0006\u0001\u0005\u0015d\u0001C\u0001\u0003\t\u0003\u0005\t\u0011A\b\u0003+\r\u000b7\r[5oON\u0003\u0018M]9m\u000b:$\u0007o\\5oi*\u00111\u0001B\u0001\nI\u0016\u001cwN]1u_JT!!\u0002\u0004\u0002\t\r|'/\u001a\u0006\u0003\u000f!\taa\u001d9beFd'BA\u0005\u000b\u0003\u001d\u0019w.\\7p]NT!a\u0003\u0007\u0002\t\u0005\\7o\u001e\u0006\u0002\u001b\u0005\u0019qN]4\u0004\u0001M!\u0001\u0001\u0005\r\u001d!\t\tb#D\u0001\u0013\u0015\t\u0019B#\u0001\u0003mC:<'\"A\u000b\u0002\t)\fg/Y\u0005\u0003/I\u0011aa\u00142kK\u000e$\bCA\r\u001b\u001b\u0005!\u0011BA\u000e\u0005\u00059\u0019\u0006/\u0019:rY\u0016sG\r]8j]R\u0004\"!\b\u0011\u000e\u0003yQ\u0011aH\u0001\u0006g\u000e\fG.Y\u0005\u0003Cy\u00111bU2bY\u0006|%M[3di\"A1\u0005\u0001BC\u0002\u0013\u0005A%A\u0005eK\u000e|'/\u0019;fKV\t\u0001\u0004\u0003\u0005'\u0001\t\u0005\t\u0015!\u0003\u0019\u0003)!WmY8sCR,W\r\t\u0005\tQ\u0001\u0011)\u0019!C\u0001S\u0005A!-Y:f!\u0006$\b.F\u0001+!\t\t2&\u0003\u0002-%\t11\u000b\u001e:j]\u001eD\u0001B\f\u0001\u0003\u0002\u0003\u0006IAK\u0001\nE\u0006\u001cX\rU1uQ\u0002BQ\u0001\r\u0001\u0005\u0002E\na\u0001P5oSRtDc\u0001\u001a5kA\u00111\u0007A\u0007\u0002\u0005!)1e\fa\u00011!)\u0001f\fa\u0001U!)q\u0007\u0001C\u0005q\u00051An\\4hKJ,\u0012!\u000f\t\u0003uuj\u0011a\u000f\u0006\u0003y1\tQa\u001d7gi)L!AP\u001e\u0003\r1{wmZ3s\u0011\u0015\u0001\u0005\u0001\"\u0001B\u00031iG-N*v[N#(/\u001b8h)\tQ#\tC\u0003D\u007f\u0001\u0007A)A\u0003csR,7\u000fE\u0002\u001e\u000b\u001eK!A\u0012\u0010\u0003\u000b\u0005\u0013(/Y=\u0011\u0005uA\u0015BA%\u001f\u0005\u0011\u0011\u0015\u0010^3\t\u000b-\u0003A\u0011\u0001'\u0002\t5\f\u0017N\u001c\u000b\u0003\u001bB\u0003\"!\b(\n\u0005=s\"\u0001B+oSRDQ!\u0015&A\u0002I\u000bA!\u0019:hgB\u0019Q$\u0012\u0016\t\u000bQ\u0003A\u0011A+\u0002#\u0011,g-Y;mi\u001e\u0013\u0018\r\u001d5OC6,7\u000fF\u0001W!\r9&,\u0018\b\u0003;aK!!\u0017\u0010\u0002\rA\u0013X\rZ3g\u0013\tYFLA\u0002TKRT!!\u0017\u0010\u0011\u0005]s\u0016B\u0001\u0017]\u0011\u0015\u0001\u0007\u0001\"\u0001b\u0003A)\u00070Z2vi\u0016\u001cuN\\:ueV\u001cG\u000f\u0006\u0002ceB\u00111\r]\u0007\u0002I*\u0011QMZ\u0001\u0006[>$W\r\u001c\u0006\u0003O\"\f1A\u001d3g\u0015\tI'.\u0001\u0003kK:\f'BA6m\u0003\rA\u0007\u000f\u001c\u0006\u0003[:\f!\u0001\u001b9\u000b\u0003=\f1aY8n\u0013\t\tHMA\u0003N_\u0012,G\u000eC\u0003t?\u0002\u0007!&A\u0003rk\u0016\u0014\u0018\u0010C\u0003a\u0001\u0011\u0005Q\u000fF\u0002cm^DQa\u001d;A\u0002)BQ!\u001a;A\u0002\tDQ!\u001f\u0001\u0005\u0002i\f!\"\u001a=fGV$X-Q:l)\tYh\u0010\u0005\u0002\u001ey&\u0011QP\b\u0002\b\u0005>|G.Z1o\u0011\u0015\u0019\b\u00101\u0001+\u0011\u001d\t\t\u0001\u0001C\u0001\u0003\u0007\t\u0001#\u001a=fGV$XmU3mK\u000e$\b,\u001c7\u0015\t\u0005\u0015\u0011q\u0002\t\u0005\u0003\u000f\tY!\u0004\u0002\u0002\n)\u00111\u000f[\u0005\u0005\u0003\u001b\tIAA\u0005SKN,H\u000e^*fi\")1o a\u0001U!9\u00111\u0003\u0001\u0005\u0002\u0005U\u0011!F3yK\u000e,H/Z*fY\u0016\u001cG/\u00138NK6|'/\u001f\u000b\u0005\u0003\u000b\t9\u0002\u0003\u0004t\u0003#\u0001\rA\u000b\u0005\b\u00037\u0001A\u0011AA\u000f\u0003E\u0019\u0017m\u00195f%\u0016\u001cX\u000f\u001c;TKRDV\u000e\u001c\u000b\u0006\u001b\u0006}\u00111\u0005\u0005\t\u0003C\tI\u00021\u0001\u0002\u0006\u0005\u0011!o\u001d\u0005\t\u0003K\tI\u00021\u0001\u0002(\u0005!a-\u001b7f!\u0011\tI#a\f\u000e\u0005\u0005-\"bAA\u0017)\u0005\u0011\u0011n\\\u0005\u0005\u0003c\tYC\u0001\u0003GS2,\u0007bBA\u001b\u0001\u0011\u0005\u0011qG\u0001\u000eKb,7-\u001e;f'\u0016dWm\u0019;\u0015\t\u0005\u0015\u0011\u0011\b\u0005\u0007g\u0006M\u0002\u0019\u0001\u0016\t\u000f\u0005u\u0002\u0001\"\u0001\u0002@\u0005I1-Y2iK\u001aKG.\u001a\u000b\t\u0003O\t\t%!\u0012\u0002L!9\u00111IA\u001e\u0001\u0004Q\u0013AA5e\u0011!\t9%a\u000fA\u0002\u0005%\u0013AC4sCBDg*Y7fgB\u0019qK\u0017\u0016\t\rM\fY\u00041\u0001+\u0011\u001d\ty\u0005\u0001C\u0001\u0003#\n1bY1dQ\u0016dun\\6vaR!\u00111KA0!\u0015i\u0012QKA-\u0013\r\t9F\b\u0002\u0007\u001fB$\u0018n\u001c8\u0011\t\u0005%\u00121L\u0005\u0005\u0003;\nYCA\u0006J]B,Ho\u0015;sK\u0006l\u0007\u0002CA\u0013\u0003\u001b\u0002\r!a\n\t\u000f\u0005\r\u0003\u0001\"\u0011\u0002dQ\t!\u0006")
public class CachingSparqlEndpoint
implements SparqlEndpoint,
ScalaObject {
    private final SparqlEndpoint decoratee;
    private final String basePath;

    public String like(String variable, scala.collection.immutable.Set patterns) {
        return SparqlEndpoint$class.like((SparqlEndpoint)this, variable, patterns);
    }

    public String like(String variable, Set patterns) {
        return SparqlEndpoint$class.like((SparqlEndpoint)this, variable, patterns);
    }

    @Override
    public void insert(Model model, String graphName) {
        SparqlEndpoint$class.insert(this, model, graphName);
    }

    @Override
    public void remove(Model model, String graphName) {
        SparqlEndpoint$class.remove(this, model, graphName);
    }

    @Override
    public boolean isAlive() {
        return SparqlEndpoint$class.isAlive(this);
    }

    public SparqlEndpoint decoratee() {
        return this.decoratee;
    }

    public String basePath() {
        return this.basePath;
    }

    private Logger logger() {
        return LoggerFactory.getLogger(CachingSparqlEndpoint.class);
    }

    public String md5SumString(byte[] bytes) {
        MessageDigest md5 = MessageDigest.getInstance("MD5");
        md5.reset();
        md5.update(bytes);
        return (String)Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.intArrayOps((int[])Predef$.MODULE$.byteArrayOps(md5.digest()).map((Function1)new $anonfun$md5SumString$1(this), Array$.MODULE$.canBuildFrom((ClassManifest)Manifest$.MODULE$.Int()))).map((Function1)new $anonfun$md5SumString$2(this), Array$.MODULE$.canBuildFrom(ClassManifest$.MODULE$.classType(String.class)))).foldLeft((Object)"", (Function2)new $anonfun$md5SumString$3(this));
    }

    public void main(String[] args) {
        HttpSparqlEndpoint coreEndpoint = new HttpSparqlEndpoint("localhost:8890/sparql", (scala.collection.immutable.Set<String>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"http://dbpedia.org"}))));
        CachingSparqlEndpoint endpoint$1 = new CachingSparqlEndpoint(coreEndpoint, "/tmp/sparqlCache");
        QueryCollection qc = new QueryCollection(coreEndpoint, "Select ?s ?p ?o From <http://dbpedia.org> { ?s ?p ?p . } Limit 10000");
        ((IterableLike)qc.zipWithIndex(Iterable$.MODULE$.canBuildFrom())).foreach((Function1)new $anonfun$main$1(this, endpoint$1));
    }

    @Override
    public scala.collection.immutable.Set<String> defaultGraphNames() {
        return this.decoratee().defaultGraphNames();
    }

    @Override
    public Model executeConstruct(String query) {
        return this.decoratee().executeConstruct(query);
    }

    @Override
    public Model executeConstruct(String query, Model model) {
        return this.decoratee().executeConstruct(query, model);
    }

    @Override
    public boolean executeAsk(String query) {
        return this.decoratee().executeAsk(query);
    }

    public ResultSet executeSelectXml(String query) {
        this.logger().trace(new StringBuilder().append((Object)"Query is: ").append((Object)query).toString());
        File file = this.cacheFile(this.decoratee().id(), this.decoratee().defaultGraphNames(), query);
        this.logger().trace(new StringBuilder().append((Object)"Cache file: ").append((Object)file.getAbsolutePath()).toString());
        Option<InputStream> option = this.cacheLookup(file);
        if (option instanceof Some) {
            InputStream inputStream;
            Some some = (Some)option;
            InputStream in = inputStream = (InputStream)some.x();
            return new ClosingResultSet(ResultSetFactory.fromXML((InputStream)in), in);
        }
        None$ none$ = None$.MODULE$;
        Option<InputStream> option2 = option;
        if (!(none$ != null ? !none$.equals(option2) : option2 != null)) {
            ResultSet rs = this.decoratee().executeSelect(query);
            this.cacheResultSetXml(rs, file);
            FileInputStream in = new FileInputStream(file);
            return new ClosingResultSet(ResultSetFactory.fromXML((InputStream)in), in);
        }
        throw new MatchError(option);
    }

    public ResultSet executeSelectInMemory(String query) {
        this.logger().trace(new StringBuilder().append((Object)"Query is: ").append((Object)query).toString());
        File file = this.cacheFile(this.decoratee().id(), this.decoratee().defaultGraphNames(), query);
        this.logger().trace(new StringBuilder().append((Object)"Cache file: ").append((Object)file.getAbsolutePath()).toString());
        Option<InputStream> option = this.cacheLookup(file);
        if (option instanceof Some) {
            InputStream inputStream;
            Some some = (Some)option;
            InputStream in = inputStream = (InputStream)some.x();
            ResultSetRewindable result = ResultSetFactory.makeRewindable((ResultSet)ResultSetFactory.fromXML((InputStream)in));
            in.close();
            return result;
        }
        None$ none$ = None$.MODULE$;
        Option<InputStream> option2 = option;
        if (!(none$ != null ? !none$.equals(option2) : option2 != null)) {
            ResultSet tmpRs = this.decoratee().executeSelect(query);
            ResultSetRewindable rs = ResultSetFactory.makeRewindable((ResultSet)tmpRs);
            this.cacheResultSetXml((ResultSet)rs, file);
            rs.reset();
            return rs;
        }
        throw new MatchError(option);
    }

    public void cacheResultSetXml(ResultSet rs, File file) {
        File directory = file.getParentFile();
        directory.mkdirs();
        File tmpFile = File.createTempFile("sparqlResultSet_", ".tmp", directory);
        FileOutputStream out = new FileOutputStream(tmpFile);
        ResultSetFormatter.outputAsXML((OutputStream)out, (ResultSet)rs);
        tmpFile.renameTo(file);
        return;
        finally {
            out.flush();
            out.close();
        }
    }

    @Override
    public ResultSet executeSelect(String query) {
        return this.executeSelectXml(query);
    }

    public File cacheFile(String id, scala.collection.immutable.Set<String> graphNames, String query) {
        String dirPart = new StringBuilder().append((Object)this.basePath()).append((Object)"/").append((Object)URLEncoder.encode(id, "UTF-8")).append((Object)"/").toString();
        String dir = new StringBuilder().append((Object)dirPart).append((Object)(graphNames.isEmpty() ? "default/" : new StringBuilder().append((Object)URLEncoder.encode(graphNames.mkString("_"), "UTF-8")).append((Object)"/").toString())).toString();
        File file = new File(new StringBuilder().append((Object)"").append((Object)dir).append((Object)this.md5SumString(query.getBytes())).toString());
        return file;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Option<InputStream> cacheLookup(File file) {
        Object object;
        if (!file.exists()) {
            object = BoxedUnit.UNIT;
            return None$.MODULE$;
        }
        boolean exceptionResult1 = false;
        try {
            this.logger().debug(new StringBuilder().append((Object)"Cache hit for: ").append((Object)file).toString());
            return new Some((Object)new FileInputStream(file));
        }
        catch (Throwable throwable) {
            void var2_2;
            this.logger().debug("Corrupted cache - deleting file");
            exceptionResult1 = file.delete();
            object = BoxesRunTime.boxToBoolean((boolean)var2_2);
        }
        return None$.MODULE$;
    }

    @Override
    public String id() {
        return new StringBuilder().append((Object)"cached_").append((Object)this.decoratee().id()).toString();
    }

    public CachingSparqlEndpoint(SparqlEndpoint decoratee, String basePath) {
        this.decoratee = decoratee;
        this.basePath = basePath;
        SparqlEndpoint$class.$init$(this);
    }
}

