/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.commons.jena.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import net.sf.oval.constraint.Min;
import net.sf.oval.constraint.NotEmpty;
import net.sf.oval.constraint.NotNull;
import net.sf.oval.constraint.Range;
import net.sf.oval.guard.Guarded;
import org.aksw.commons.jena.util.CommonProperties;

@Guarded(applyFieldConstraintsToConstructors=true)
public class CachedCommonProperties {
    private final Map<Integer, LinkedHashMap<String, Integer>> whereToProperties;
    @NotNull
    private final File cacheFile;
    @NotNull
    @NotEmpty
    private final String endpoint;
    @Range(min=0.0, max=1.0)
    private final Double threshold;
    @Min(value=1.0)
    private final Integer maxResultSize;
    @Min(value=1.0)
    private final Integer sampleSize;
    public boolean offline = false;

    public LinkedHashMap<String, Integer> getCommonProperties(@NotNull @NotEmpty String where) {
        int hash = where.hashCode();
        LinkedHashMap<String, Integer> properties = this.whereToProperties.get(hash);
        if (properties == null && !this.offline) {
            properties = CommonProperties.getCommonProperties(this.endpoint, where, this.threshold, this.maxResultSize, this.sampleSize);
            this.whereToProperties.put(hash, properties);
        }
        return properties;
    }

    public CachedCommonProperties(File cacheFile, String endpoint, Double threshold, Integer maxResultSize, Integer sampleSize) throws IOException {
        this.cacheFile = cacheFile;
        this.endpoint = endpoint;
        this.threshold = threshold;
        this.maxResultSize = maxResultSize;
        this.sampleSize = sampleSize;
        this.whereToProperties = cacheFile.exists() ? this.load() : new HashMap<Integer, LinkedHashMap<String, Integer>>();
    }

    private HashMap<Integer, LinkedHashMap<String, Integer>> load() throws IOException {
        FileInputStream fis = null;
        fis = new FileInputStream(this.cacheFile);
        ObjectInputStream o = new ObjectInputStream(fis);
        try {
            return (HashMap)o.readObject();
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
            return new HashMap<Integer, LinkedHashMap<String, Integer>>();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void save() throws IOException {
        FileOutputStream fos = new FileOutputStream(this.cacheFile);
        ObjectOutputStream o = new ObjectOutputStream(fos);
        Map<Integer, LinkedHashMap<String, Integer>> map = this.whereToProperties;
        synchronized (map) {
            o.writeObject(this.whereToProperties);
        }
        ((OutputStream)fos).close();
    }
}

