/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.commons.sparql.core;

import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.apache.velocity.Template;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.VelocityEngine;
import org.apache.velocity.context.Context;
import org.apache.velocity.runtime.resource.loader.ClasspathResourceLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SparqlTemplate {
    private static final Logger logger = LoggerFactory.getLogger(SparqlTemplate.class);
    private static VelocityEngine ve = null;
    private Template template;
    private VelocityContext velocityContext = new VelocityContext();
    private boolean usePrefixes = true;
    private int limit = 1000;
    private Set<String> from = new HashSet<String>();
    private Set<String> filter = new HashSet<String>();

    public static VelocityEngine getClassPathEngine() {
        if (ve == null) {
            try {
                ve = new VelocityEngine();
                ve.setProperty("resource.loader", (Object)"classpath");
                ve.setProperty("classpath.resource.loader.class", (Object)ClasspathResourceLoader.class.getName());
                ve.init();
            }
            catch (Exception e) {
                logger.error("", (Throwable)e);
            }
        }
        return ve;
    }

    public static SparqlTemplate getInstance(String classpathFile) throws Exception {
        return new SparqlTemplate(SparqlTemplate.getClassPathEngine().getTemplate(classpathFile));
    }

    public SparqlTemplate(Template template) {
        this.template = template;
    }

    public void addFrom(String s) {
        this.from.add(s);
    }

    public void addFrom(Collection<String> c) {
        this.from.addAll(c);
    }

    public void addFilter(String s) {
        this.filter.add(s);
    }

    public void addFilter(Collection<String> c) {
        this.filter.addAll(c);
    }

    public VelocityContext getVelocityContext() {
        return this.velocityContext;
    }

    public boolean isUsePrefixes() {
        return this.usePrefixes;
    }

    public void setUsePrefixes(boolean usePrefixes) {
        this.usePrefixes = usePrefixes;
    }

    public int getLimit() {
        return this.limit;
    }

    public void setLimit(int limit) {
        this.limit = limit;
    }

    public String getQuery() {
        this.velocityContext.put("limit", (Object)this.limit);
        if (!this.from.isEmpty()) {
            this.velocityContext.put("fromList", new ArrayList<String>(this.from));
        }
        if (!this.filter.isEmpty()) {
            this.velocityContext.put("filterList", new ArrayList<String>(this.filter));
        }
        if (this.usePrefixes) {
            this.velocityContext.put("prefix", (Object)this.usePrefixes);
        }
        StringWriter writer = new StringWriter();
        try {
            this.template.merge((Context)this.velocityContext, (Writer)writer);
        }
        catch (Exception e) {
            logger.error("", (Throwable)e);
        }
        return writer.toString();
    }
}

