/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.commons.jena.util;

import com.hp.hpl.jena.query.QuerySolution;
import com.hp.hpl.jena.query.ResultSet;
import com.hp.hpl.jena.sparql.engine.http.QueryEngineHTTP;
import java.util.LinkedHashMap;
import net.sf.oval.constraint.Min;
import net.sf.oval.constraint.NotEmpty;
import net.sf.oval.constraint.NotNull;
import net.sf.oval.constraint.Range;
import net.sf.oval.guard.Guarded;

@Guarded
public class CommonProperties {
    public static LinkedHashMap<String, Integer> getCommonProperties(@NotEmpty @NotNull String endpoint, @NotEmpty @NotNull String where, @Range(min=0.0, max=1.0) Double threshold, @Min(value=1.0) Integer maxResultSize, @Min(value=1.0) Integer sampleSize) {
        String sampleSizeLimit = sampleSize == null ? "" : "limit " + sampleSize;
        String maxResultSizeLimit = maxResultSize == null ? "" : "limit " + maxResultSize;
        String innerSubquery = "select ?s where {" + where + "}" + sampleSizeLimit;
        String outerSubquery = "select distinct ?s ?p where {?s ?p ?o. {" + innerSubquery + "}}";
        String query = "select ?p, count(?p) as ?count where {{" + outerSubquery + "}} ORDER BY DESC(?count) " + maxResultSizeLimit;
        System.out.println(query);
        ResultSet rs = new QueryEngineHTTP(endpoint, query).execSelect();
        LinkedHashMap<String, Integer> commonProperties = new LinkedHashMap<String, Integer>();
        int minCount = (int)Math.ceil(threshold * (double)sampleSize.intValue());
        while (rs.hasNext() && commonProperties.size() < maxResultSize) {
            QuerySolution qs = rs.next();
            int count = Integer.valueOf(qs.getLiteral("count").getLexicalForm());
            if (count < minCount) break;
            commonProperties.put(qs.getResource("p").getURI(), count);
        }
        return commonProperties;
    }
}

