/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.commons.owlapi.reasoning.impl;

import com.clarkparsia.modularity.PelletIncremantalReasonerFactory;
import java.util.HashSet;
import java.util.Set;
import org.aksw.commons.owlapi.reasoning.IncrementalClassifier;
import org.aksw.commons.owlapi.reasoning.impl.SubsumptionResult;
import org.semanticweb.owlapi.apibinding.OWLManager;
import org.semanticweb.owlapi.model.AddAxiom;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLAxiomChange;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLDataFactory;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyChange;
import org.semanticweb.owlapi.model.OWLOntologyCreationException;
import org.semanticweb.owlapi.model.OWLOntologyManager;
import org.semanticweb.owlapi.model.RemoveAxiom;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PelletIncrementalClassifier
implements IncrementalClassifier {
    private static final Logger logger = LoggerFactory.getLogger(PelletIncrementalClassifier.class);
    private OWLDataFactory factory;
    private OWLOntologyManager manager;
    private OWLOntology ontology;
    private com.clarkparsia.modularity.IncrementalClassifier incReasoner;
    Set<OWLAxiom> previouslyAddedAxioms = new HashSet<OWLAxiom>();
    private boolean getSuperClasses = true;
    private boolean getEquivalentClasses = false;
    private boolean getSubClasses = true;
    private boolean getParallelClasses = false;

    public PelletIncrementalClassifier(OWLOntology ontology, com.clarkparsia.modularity.IncrementalClassifier incReasoner) {
        this.ontology = ontology;
        this.manager = ontology.getOWLOntologyManager();
        this.factory = this.manager.getOWLDataFactory();
        this.incReasoner = incReasoner;
        incReasoner.prepareReasoner();
        logger.debug("Successfully initialized reasoner");
    }

    public static PelletIncrementalClassifier getInstance(OWLOntology ontology) {
        com.clarkparsia.modularity.IncrementalClassifier inc = PelletIncremantalReasonerFactory.getInstance().createNonBufferingReasoner(ontology);
        return new PelletIncrementalClassifier(ontology, inc);
    }

    public static PelletIncrementalClassifier getInstance(IRI iri) throws OWLOntologyCreationException {
        OWLOntologyManager manager = OWLManager.createOWLOntologyManager();
        OWLOntology ontology = manager.loadOntology(iri);
        return PelletIncrementalClassifier.getInstance(ontology);
    }

    @Override
    public SubsumptionResult getSubsumptionResult(String classUri, boolean direct) {
        OWLClass cl = this.factory.getOWLClass(IRI.create((String)classUri));
        return this.getSubsumptionResult(cl, direct);
    }

    public SubsumptionResult getSubsumptionResult(OWLClass cl, boolean direct) {
        SubsumptionResult sr = new SubsumptionResult();
        if (this.getSuperClasses) {
            sr.superClasses = this.incReasoner.getSuperClasses((OWLClassExpression)cl, direct).getFlattened();
        }
        if (this.getSubClasses) {
            sr.subClasses = this.incReasoner.getSuperClasses((OWLClassExpression)cl, direct).getFlattened();
        }
        if (this.getEquivalentClasses) {
            sr.equivalentClasses = new HashSet<OWLClass>(sr.subClasses);
            sr.equivalentClasses.retainAll(sr.superClasses);
        }
        if (this.getParallelClasses) {
            sr.superClasses = this.incReasoner.getSuperClasses((OWLClassExpression)cl, direct).getFlattened();
        }
        logger.debug("Found for " + cl.toString() + "\n" + sr);
        return sr;
    }

    public void addAxioms(Set<OWLAxiom> axioms) {
        this.previouslyAddedAxioms.addAll(axioms);
        HashSet<OWLAxiomChange> s = new HashSet<OWLAxiomChange>();
        for (OWLAxiom ax : axioms) {
            s.add((OWLAxiomChange)new AddAxiom(this.ontology, ax));
        }
        this.change(s);
    }

    public void removeAxioms(Set<OWLAxiom> axioms) {
        this.previouslyAddedAxioms.removeAll(axioms);
        HashSet<OWLAxiomChange> s = new HashSet<OWLAxiomChange>();
        for (OWLAxiom ax : axioms) {
            s.add((OWLAxiomChange)new RemoveAxiom(this.ontology, ax));
        }
        this.change(s);
    }

    private void change(Set<OWLAxiomChange> axioms) {
        int before = this.ontology.getAxiomCount();
        for (OWLAxiomChange owlAxiom : axioms) {
            this.manager.applyChange((OWLOntologyChange)owlAxiom);
            if (owlAxiom instanceof AddAxiom) {
                logger.debug("Added axiom " + owlAxiom.toString());
                continue;
            }
            if (!(owlAxiom instanceof RemoveAxiom)) continue;
            logger.debug("Removed axiom " + owlAxiom.toString());
        }
        this.incReasoner.prepareReasoner();
        this.validate(before, this.ontology.getAxiomCount(), axioms.size());
    }

    public void removeAllpreviouslyAddedAxioms() {
        this.removeAxioms(this.previouslyAddedAxioms);
        this.previouslyAddedAxioms = new HashSet<OWLAxiom>();
    }

    private void validate(int before, int after, int expectedDifference) {
        if (Math.abs(before - after) != expectedDifference) {
            String message = "adding/removing axioms failed:\n";
            message = message + "before:" + before + "\n";
            message = message + "after:" + after + "\n";
            message = message + "expected difference:" + expectedDifference + "\n";
            logger.error(message);
        }
    }
}

