/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.commons.owlapi.reasoning;

import com.clarkparsia.modularity.IncrementalClassifier;
import com.clarkparsia.modularity.PelletIncremantalReasonerFactory;
import com.jamonapi.Monitor;
import com.jamonapi.MonitorFactory;
import java.util.ArrayList;
import java.util.List;
import org.aksw.commons.util.Time;
import org.mindswap.pellet.PelletOptions;
import org.semanticweb.owlapi.apibinding.OWLManager;
import org.semanticweb.owlapi.model.AddAxiom;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyManager;
import org.semanticweb.owlapi.reasoner.OWLReasoner;
import org.semanticweb.owlapi.util.InferredAxiomGenerator;
import org.semanticweb.owlapi.util.InferredClassAssertionAxiomGenerator;
import org.semanticweb.owlapi.util.InferredDataPropertyCharacteristicAxiomGenerator;
import org.semanticweb.owlapi.util.InferredEquivalentClassAxiomGenerator;
import org.semanticweb.owlapi.util.InferredEquivalentDataPropertiesAxiomGenerator;
import org.semanticweb.owlapi.util.InferredEquivalentObjectPropertyAxiomGenerator;
import org.semanticweb.owlapi.util.InferredInverseObjectPropertiesAxiomGenerator;
import org.semanticweb.owlapi.util.InferredObjectPropertyCharacteristicAxiomGenerator;
import org.semanticweb.owlapi.util.InferredPropertyAssertionGenerator;
import org.semanticweb.owlapi.util.InferredSubClassAxiomGenerator;
import org.semanticweb.owlapi.util.InferredSubDataPropertyAxiomGenerator;
import org.semanticweb.owlapi.util.InferredSubObjectPropertyAxiomGenerator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MaterializeModel {
    private static final Logger logger = LoggerFactory.getLogger(MaterializeModel.class);
    public static PelletOptions.MonitorType monitorType = PelletOptions.MonitorType.NONE;

    public static OWLOntology convertToInferredModel(OWLOntology ontology) {
        PelletOptions.USE_CLASSIFICATION_MONITOR = monitorType;
        logger.info("" + ontology.getAxiomCount());
        Monitor m = MonitorFactory.getTimeMonitor((String)(MaterializeModel.class.getSimpleName() + ".convertToInferredModel")).start();
        OWLOntologyManager man = OWLManager.createOWLOntologyManager();
        IncrementalClassifier reasoner = PelletIncremantalReasonerFactory.getInstance().createNonBufferingReasoner(ontology);
        List<InferredAxiomGenerator<? extends OWLAxiom>> axiomGenerators = MaterializeModel.getAxiomGenerators();
        ArrayList<AddAxiom> changes = new ArrayList<AddAxiom>();
        for (InferredAxiomGenerator<? extends OWLAxiom> axiomGenerator : axiomGenerators) {
            for (OWLAxiom ax : axiomGenerator.createAxioms(man, (OWLReasoner)reasoner)) {
                changes.add(new AddAxiom(ontology, ax));
            }
        }
        man.applyChanges(changes);
        logger.info("Inference finished " + Time.neededMs((double)m.stop().getLastValue()));
        logger.info("" + ontology.getAxiomCount());
        return ontology;
    }

    public static List<InferredAxiomGenerator<? extends OWLAxiom>> getAxiomGenerators() {
        ArrayList<InferredAxiomGenerator<? extends OWLAxiom>> axiomGenerators = new ArrayList<InferredAxiomGenerator<? extends OWLAxiom>>();
        axiomGenerators.add((InferredAxiomGenerator<? extends OWLAxiom>)new InferredSubClassAxiomGenerator());
        axiomGenerators.add((InferredAxiomGenerator<? extends OWLAxiom>)new InferredPropertyAssertionGenerator());
        axiomGenerators.add((InferredAxiomGenerator<? extends OWLAxiom>)new InferredClassAssertionAxiomGenerator());
        axiomGenerators.add((InferredAxiomGenerator<? extends OWLAxiom>)new InferredDataPropertyCharacteristicAxiomGenerator());
        axiomGenerators.add((InferredAxiomGenerator<? extends OWLAxiom>)new InferredEquivalentClassAxiomGenerator());
        axiomGenerators.add((InferredAxiomGenerator<? extends OWLAxiom>)new InferredEquivalentDataPropertiesAxiomGenerator());
        axiomGenerators.add((InferredAxiomGenerator<? extends OWLAxiom>)new InferredEquivalentObjectPropertyAxiomGenerator());
        axiomGenerators.add((InferredAxiomGenerator<? extends OWLAxiom>)new InferredInverseObjectPropertiesAxiomGenerator());
        axiomGenerators.add((InferredAxiomGenerator<? extends OWLAxiom>)new InferredObjectPropertyCharacteristicAxiomGenerator());
        axiomGenerators.add((InferredAxiomGenerator<? extends OWLAxiom>)new InferredPropertyAssertionGenerator());
        axiomGenerators.add((InferredAxiomGenerator<? extends OWLAxiom>)new InferredSubDataPropertyAxiomGenerator());
        axiomGenerators.add((InferredAxiomGenerator<? extends OWLAxiom>)new InferredSubObjectPropertyAxiomGenerator());
        return axiomGenerators;
    }
}

