/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.commons.jena.impl;

import com.hp.hpl.jena.ontology.OntModel;
import com.hp.hpl.jena.ontology.OntModelSpec;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLEncoder;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import org.aksw.commons.jena.OntologyLoader;
import org.aksw.commons.jena.impl.SimpleLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OntologyCache
extends SimpleLoader
implements OntologyLoader {
    private static final Logger log = LoggerFactory.getLogger(OntologyCache.class);
    private final String cacheDir;

    public OntologyCache(String cacheDir) {
        this.cacheDir = cacheDir;
        File f = new File(cacheDir);
        if (!f.exists()) {
            f.mkdir();
        }
    }

    @Override
    public OntModel loadOntology(String ontologyUri) {
        OntModel model = ModelFactory.createOntologyModel((OntModelSpec)OntModelSpec.OWL_DL_MEM, (Model)ModelFactory.createDefaultModel());
        try {
            if (!this.isOntologyCached(ontologyUri)) {
                this.cache(ontologyUri);
                log.info("ontology " + ontologyUri + " was cached. To refresh, delete folder: " + new File(this.cacheDir).getAbsolutePath());
            }
            model.read(new File(this.makeFilenameFromOntologyUrl(ontologyUri)).toURI().toURL().toString());
            log.info("ontology " + ontologyUri + " was loaded from cache. To refresh, delete folder: " + new File(this.cacheDir).getAbsolutePath());
        }
        catch (IOException e) {
            log.warn("caching ontology failed, trying to load from url");
            model.read(ontologyUri);
        }
        catch (Exception e) {
            log.error("Could not load cached ontology trying to download", (Throwable)e);
        }
        return model;
    }

    public void clearCache() {
        File[] files;
        for (File file : files = this.listAllFiles()) {
            try {
                if (!file.delete()) continue;
                log.info("Deleted file " + file.toString());
            }
            catch (Exception e) {
                log.warn("could not delete file");
            }
        }
    }

    private File[] listAllFiles() {
        File f = new File(this.cacheDir);
        return f.listFiles();
    }

    public void download(String from, String to) throws IOException {
        try {
            URL google = new URL(from);
            ReadableByteChannel rbc = Channels.newChannel(google.openStream());
            FileOutputStream fos = new FileOutputStream(to);
            fos.getChannel().transferFrom(rbc, 0L, 0x1000000L);
            log.debug("successfully downloaded " + from + " to " + to + " ");
        }
        catch (IOException e) {
            log.warn("caching the ontology failed " + from, (Throwable)e);
        }
    }

    private String makeFilenameFromOntologyUrl(String ontologyUrl) throws UnsupportedEncodingException {
        return this.cacheDir + URLEncoder.encode(ontologyUrl, "UTF-8");
    }

    private void cache(String ontologyUrl) throws IOException {
        this.download(ontologyUrl, this.makeFilenameFromOntologyUrl(ontologyUrl));
    }

    public static void main(String[] args) throws IOException {
        OntologyCache oc = new OntologyCache("/tmp/");
        OntModel m = oc.loadOntology("http://nachhalt.sfb632.uni-potsdam.de/owl/stanford.owl");
        oc.loadImports(m);
    }

    public boolean isOntologyCached(String ontologyUri) {
        try {
            return new File(this.makeFilenameFromOntologyUrl(ontologyUri)).exists();
        }
        catch (Exception e) {
            log.error("", (Throwable)e);
            return false;
        }
    }
}

