/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.commons.graph;

import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.rdf.model.Resource;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.aksw.commons.collections.CacheSet;
import org.aksw.commons.graph.IndexTable;
import org.aksw.commons.graph.TripleUtils;
import org.apache.commons.collections15.map.LRUMap;

public class TripleIndexUtils {
    public static List<Object> getMatchingKey(Set<List<Object>> keys, Triple triple, int[] keyColumns) {
        List<Object> key = TripleIndexUtils.tripleToList(triple, keyColumns);
        return keys.contains(key) ? key : null;
    }

    public static <T> Set<List<Object>> getOrCreate2(Map<List<T>, Set<List<Object>>> map, List<T> key) {
        Set<List<Object>> result = map.get(key);
        if (result == null) {
            result = new HashSet<List<Object>>();
            map.put(key, result);
        }
        return result;
    }

    public static <T> IndexTable getOrCreate(Map<List<T>, IndexTable> map, List<T> key) {
        IndexTable result = map.get(key);
        if (result == null) {
            result = new IndexTable();
            map.put(key, result);
        }
        return result;
    }

    public static List<Object> tripleToList(Triple triple, int[] indexes) {
        Object[] array = new Object[indexes.length];
        for (int i = 0; i < array.length; ++i) {
            array[i] = TripleUtils.get(triple, indexes[i]);
        }
        if (array.length == 1) {
            return Collections.singletonList(array[0]);
        }
        ArrayList<Object> result = new ArrayList<Object>();
        for (Object item : array) {
            result.add(item);
        }
        return result;
    }

    public static Map<List<Object>, Set<List<Object>>> index2(Collection<Triple> triples, int[] keyColumns) {
        return TripleIndexUtils.index2(triples, keyColumns, TripleIndexUtils.getValueColumns(keyColumns));
    }

    public static Map<List<Object>, Set<List<Object>>> index2(Collection<Triple> triples, int[] keyColumns, int[] valueColumns) {
        HashMap tmp = new HashMap();
        for (Triple triple : triples) {
            List<Object> key = TripleIndexUtils.tripleToList(triple, keyColumns);
            List<Object> value = TripleIndexUtils.tripleToList(triple, valueColumns);
            TripleIndexUtils.getOrCreate2(tmp, key).add(value);
        }
        return tmp;
    }

    public static Map<List<Object>, IndexTable> index(Collection<Triple> triples, int[] keyColumns) {
        return TripleIndexUtils.index(triples, keyColumns, TripleIndexUtils.getValueColumns(keyColumns));
    }

    public static Map<List<Object>, IndexTable> index(Collection<Triple> triples, int[] keyColumns, int[] valueColumns) {
        HashMap tmp = new HashMap();
        for (Triple triple : triples) {
            List<Object> key = TripleIndexUtils.tripleToList(triple, keyColumns);
            List<Object> value = TripleIndexUtils.tripleToList(triple, valueColumns);
            IndexTable table = TripleIndexUtils.getOrCreate(tmp, key);
            table.setComplete(true);
            table.getRows().add(value);
        }
        return tmp;
    }

    public static int[] getValueColumns(int[] keyColumns) {
        int[] valueColumns = new int[3 - keyColumns.length];
        HashSet<Integer> cs = new HashSet<Integer>();
        for (int index : keyColumns) {
            cs.add(index);
        }
        Arrays.asList(0, 1, 2).remove(cs);
        int j = 0;
        for (int i = 0; i < 3; ++i) {
            if (cs.contains(i)) continue;
            valueColumns[j++] = i;
        }
        return valueColumns;
    }

    public static Set<List<Object>> toKeys(List<Resource> resources) {
        HashSet<List<Object>> result = new HashSet<List<Object>>();
        for (Resource resource : resources) {
            result.add(Collections.singletonList(resource.asNode()));
        }
        return result;
    }

    public static <K, V> Map<K, V> createMap(Integer maxSize) {
        if (maxSize == 0) {
            maxSize = 1;
        }
        return maxSize == null ? new HashMap() : new LRUMap(maxSize.intValue());
    }

    public static <T> Set<T> createSet(Integer maxSize) {
        return maxSize == null ? new HashSet() : new CacheSet(maxSize.intValue(), true);
    }
}

