/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.commons.graph;

import com.google.common.base.Joiner;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.Statement;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.aksw.commons.graph.CacheState;
import org.aksw.commons.graph.IGraph;
import org.aksw.commons.graph.ITripleCacheIndex;
import org.aksw.commons.graph.IndexCompatibilityLevel;
import org.aksw.commons.graph.IndexTable;
import org.aksw.commons.graph.TripleIndexUtils;
import org.aksw.commons.graph.TripleUtils;
import org.apache.commons.collections15.map.LRUMap;

public class TripleCacheIndexImpl
implements ITripleCacheIndex {
    private IGraph graph;
    private boolean trackIncompletePartitions = true;
    private Map<List<Object>, Set<List<Object>>> full;
    private Map<List<Object>, Set<List<Object>>> partial;
    private Set<List<Object>> noDataCache;
    private int[] indexColumns;
    private int[] valueColumns;

    public int[] getIndexColumns() {
        return this.indexColumns;
    }

    public static TripleCacheIndexImpl create(IGraph graph, Integer fullMaxSize, Integer partialMaxSize, Integer emptyMaxSize, int ... indexColumns) throws Exception {
        Map<List<Object>, Set<List<Object>>> full = TripleIndexUtils.createMap(fullMaxSize);
        Map<List<Object>, Set<List<Object>>> partial = TripleIndexUtils.createMap(partialMaxSize);
        Set<List<Object>> set = TripleIndexUtils.createSet(emptyMaxSize);
        TripleCacheIndexImpl index = new TripleCacheIndexImpl(graph, indexColumns, full, partial, set);
        graph.getCacheProvider().getIndexes().add(index);
        return index;
    }

    private TripleCacheIndexImpl(IGraph graph, int[] indexColumns, Map<List<Object>, Set<List<Object>>> full, Map<List<Object>, Set<List<Object>>> partial, Set<List<Object>> noDataCache) throws Exception {
        this.graph = graph;
        this.indexColumns = indexColumns;
        this.valueColumns = TripleIndexUtils.getValueColumns(indexColumns);
        this.full = full;
        this.partial = partial;
        this.noDataCache = noDataCache;
    }

    public static RDFNode getItemAt(Statement stmt, int index) {
        switch (index) {
            case 0: {
                return stmt.getSubject();
            }
            case 1: {
                return stmt.getPredicate();
            }
            case 2: {
                return stmt.getObject();
            }
        }
        throw new IndexOutOfBoundsException();
    }

    public List<Object> extractKey(Statement stmt) {
        Object[] keyTmp = new Object[this.indexColumns.length];
        for (int i = 0; i < this.indexColumns.length; ++i) {
            keyTmp[i] = TripleCacheIndexImpl.getItemAt(stmt, this.indexColumns[i]);
        }
        return Arrays.asList(keyTmp);
    }

    public static <T> IndexTable getOrCreate(Map<List<T>, IndexTable> map, List<T> key) {
        IndexTable result = map.get(key);
        if (result == null) {
            result = new IndexTable();
            map.put(key, result);
        }
        return result;
    }

    public static <T> IndexTable getOrCreate(LRUMap<List<? super T>, IndexTable> map, List<T> key) {
        IndexTable result = (IndexTable)map.get(key);
        if (result == null) {
            result = new IndexTable();
            map.put(key, (Object)result);
        }
        return result;
    }

    public static <T> void fill(T[] array, Iterable<T> items, int[] map) {
        Iterator<T> it = items.iterator();
        for (int i = 0; i < map.length; ++i) {
            T item = it.next();
            array[map[i]] = item;
        }
    }

    public static Triple toTriple(Object[] array) {
        return new Triple((Node)array[0], (Node)array[1], (Node)array[2]);
    }

    void validate(List<Object> key) {
        Set<List<Object>> table;
        boolean match = false;
        if (key.get(0).toString().contains("Literary_collaborations/fold/3/phase/1/144")) {
            match = true;
            System.out.println("HERE");
        }
        if ((table = this.full.get(key)) == null) {
            for (Map.Entry<List<Object>, Set<List<Object>>> entry : this.full.entrySet()) {
                for (int i = 0; i < entry.getKey().size(); ++i) {
                    if (!match || !entry.getKey().get(i).toString().contains("Literary_collaborations/fold/3/phase/1/144")) continue;
                    System.out.println("DAMMIT");
                    System.out.println(key);
                    System.out.println(entry.getKey());
                }
            }
        }
    }

    @Override
    public Collection<Triple> lookup(List<Object> key) {
        Set<List<Object>> table = this.full.get(key);
        if (table == null) {
            if (this.noDataCache.contains(key)) {
                return Collections.emptySet();
            }
        } else {
            HashSet<Triple> result = new HashSet<Triple>();
            for (List<Object> value : table) {
                Object[] array = new Object[3];
                TripleCacheIndexImpl.fill(array, key, this.indexColumns);
                TripleCacheIndexImpl.fill(array, value, this.valueColumns);
                Triple triple = TripleCacheIndexImpl.toTriple(array);
                result.add(triple);
            }
            return result;
        }
        return null;
    }

    @Override
    public IGraph getGraph() {
        return this.graph;
    }

    @Override
    public IndexCompatibilityLevel getCompatibilityLevel(Triple pattern) {
        int count = 0;
        for (int indexColumn : this.indexColumns) {
            Node node = TripleUtils.get(pattern, indexColumn);
            count += node != null ? 1 : 0;
        }
        if (count == 0) {
            return IndexCompatibilityLevel.NONE;
        }
        if (count == this.indexColumns.length) {
            return IndexCompatibilityLevel.FULL;
        }
        return IndexCompatibilityLevel.PARTIAL;
    }

    private List<Object> tripleToKey(Triple triple) {
        return TripleIndexUtils.tripleToList(triple, this.indexColumns);
    }

    private List<Object> tripleToValue(Triple triple) {
        return TripleIndexUtils.tripleToList(triple, this.valueColumns);
    }

    @Override
    public void index(Collection<Triple> triples) {
        Map<List<Object>, Set<List<Object>>> tmp = TripleIndexUtils.index2(triples, this.indexColumns);
        for (Map.Entry<List<Object>, Set<List<Object>>> entry : tmp.entrySet()) {
            this.partial.remove(entry.getKey());
            this.noDataCache.remove(entry.getKey());
            this.full.put(entry.getKey(), entry.getValue());
        }
    }

    @Override
    public void removeSeen(Collection<Triple> triples) {
        for (Triple triple : triples) {
            List<Object> key = this.tripleToKey(triple);
            List<Object> value = this.tripleToValue(triple);
            Map<List<Object>, Set<List<Object>>> source = this.full;
            Set<List<Object>> table = source.get(key);
            if (table == null) {
                source = this.partial;
                table = this.partial.get(key);
                if (table == null) continue;
            }
            table.remove(value);
            if (!table.isEmpty()) continue;
            source.remove(key);
            if (source != this.full) continue;
            this.noDataCache.add(key);
        }
    }

    @Override
    public int[] getKeyColumns() {
        return this.indexColumns;
    }

    @Override
    public int[] getValueColumns() {
        return this.valueColumns;
    }

    @Override
    public IndexCompatibilityLevel getCompatibilityLevel(int[] columnIds) {
        HashSet<Integer> cs = new HashSet<Integer>();
        for (int id : columnIds) {
            cs.add(id);
        }
        int count = 0;
        for (int indexColumn : this.indexColumns) {
            count += cs.contains(indexColumn) ? 1 : 0;
        }
        if (count == 0) {
            return IndexCompatibilityLevel.NONE;
        }
        if (count == this.indexColumns.length) {
            return IndexCompatibilityLevel.FULL;
        }
        return IndexCompatibilityLevel.PARTIAL;
    }

    @Override
    public void addSeen(Collection<Triple> triples) {
        for (Triple triple : triples) {
            List<Object> key = this.tripleToKey(triple);
            List<Object> value = this.tripleToValue(triple);
            Set<List<Object>> table = this.full.get(key);
            if (table == null) {
                if (this.noDataCache.contains(key)) {
                    table = new HashSet<List<Object>>();
                    this.full.put(key, table);
                    this.noDataCache.remove(key);
                } else {
                    table = this.partial.get(key);
                    if (table == null) {
                        table = new HashSet<List<Object>>();
                        this.partial.put(key, table);
                    }
                }
            }
            table.add(value);
        }
    }

    @Override
    public void clear() {
        this.full.clear();
        this.partial.clear();
        this.noDataCache.clear();
    }

    public String toString() {
        return "Full/Partial/None: " + Joiner.on((String)"/").join((Object)this.full.size(), (Object)this.partial.size(), new Object[]{this.noDataCache.size()});
    }

    @Override
    public void registerMisses(Set<List<Object>> keys) {
        this.noDataCache.addAll(keys);
    }

    @Override
    public CacheState getState() {
        return new CacheState(this.full.size(), this.partial.size(), this.noDataCache.size());
    }
}

