/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.commons.graph;

import com.hp.hpl.jena.graph.Triple;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.aksw.commons.graph.BaseIndexedGraph;
import org.aksw.commons.graph.IGraphListener;
import org.aksw.commons.graph.TripleIndexUtils;

public class MemoryGraph
extends BaseIndexedGraph {
    private Set<Triple> triples = new HashSet<Triple>();

    @Override
    public void add(Collection<Triple> ts) {
        this.triples.addAll(ts);
        for (IGraphListener listener : this.listeners) {
            listener.onAdd(this, this.triples);
        }
    }

    @Override
    public void remove(Collection<Triple> ts) {
        this.triples.removeAll(ts);
        for (IGraphListener listener : this.listeners) {
            listener.onRemove(this, ts);
        }
    }

    @Override
    public Set<Triple> uncachedBulkFind(Set<List<Object>> keys, int[] keyColumns) {
        HashSet<Triple> result = new HashSet<Triple>();
        if (keyColumns.length == 0) {
            result.addAll(this.triples);
        } else {
            for (Triple triple : this.triples) {
                if (TripleIndexUtils.getMatchingKey(keys, triple, keyColumns) == null) continue;
                result.add(triple);
            }
        }
        return result;
    }

    @Override
    public void clear() {
        this.triples.clear();
    }
}

