/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.commons.graph;

import com.google.common.base.Joiner;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.Resource;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.aksw.commons.collections.CacheSet;
import org.aksw.commons.collections.CollectionUtils;
import org.aksw.commons.collections.diff.ModelDiff;
import org.aksw.commons.graph.SparqlEndpoint;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GraphBackedResourceCache {
    private static final Logger logger = LoggerFactory.getLogger(GraphBackedResourceCache.class);
    private String graphName;
    private SparqlEndpoint graphDAO;
    private int batchSize = 1024;
    private ModelDiff pendingUpdates = new ModelDiff();
    private Model cacheData = ModelFactory.createDefaultModel();
    private CacheSet<Resource> posCache = new CacheSet();
    private CacheSet<Resource> negCache = new CacheSet();

    public GraphBackedResourceCache(SparqlEndpoint graphDAO) {
        this.graphDAO = graphDAO;
    }

    public Model lookup(Collection<Resource> resources) throws Exception {
        Model result = ModelFactory.createDefaultModel();
        HashSet<Resource> ress = new HashSet<Resource>(resources);
        int negCacheHits = 0;
        int posCacheHits = 0;
        Iterator it = ress.iterator();
        while (it.hasNext()) {
            Resource resource = (Resource)it.next();
            if (this.negCache.contains((Object)resource)) {
                it.remove();
                ++negCacheHits;
                continue;
            }
            if (!this.posCache.contains((Object)resource)) continue;
            result.add(this.cacheData.listStatements(resource, null, (RDFNode)null));
            this.posCache.renew(ress);
            it.remove();
            ++posCacheHits;
        }
        Model lookup = GraphBackedResourceCache.lookupBySubject(this.graphDAO, ress, this.graphName, this.batchSize);
        Set subjects = lookup.listSubjects().toSet();
        for (Resource resource : ress) {
            if (subjects.contains(resource)) {
                Resource removed = (Resource)this.posCache.addAndGetRemoved((Object)resource);
                if (removed != null) {
                    this.cacheData.remove(removed, null, (RDFNode)null);
                }
                this.cacheData.add(lookup.listStatements(resource, null, (RDFNode)null));
                continue;
            }
            this.negCache.add((Object)resource);
        }
        result.add(lookup);
        logger.debug("Cache statistics for lookup on " + resources.size() + " resources: posHit/negHit/retrieve = " + posCacheHits + "/" + negCacheHits + "/" + ress.size());
        return result;
    }

    public void insert(Model model) throws Exception {
        Model added = ModelFactory.createDefaultModel();
        added.add(model);
        Model oldModel = this.lookup(model.listSubjects().toSet());
        added.remove(oldModel);
        this.pendingUpdates.add(added);
        for (Resource resource : model.listSubjects().toSet()) {
            if (this.negCache.contains((Object)resource)) {
                this.negCache.remove((Object)resource);
                Resource removed = (Resource)this.posCache.addAndGetRemoved((Object)resource);
                this.cacheData.remove(removed, null, (RDFNode)null);
            }
            if (!this.posCache.contains((Object)resource)) continue;
            this.cacheData.add(added.listStatements(resource, null, (RDFNode)null));
        }
    }

    public void remove(Model model) throws Exception {
        Model removed = ModelFactory.createDefaultModel();
        removed.add(model);
        Model oldModel = this.lookup(model.listSubjects().toSet());
        removed.remove(oldModel);
        this.pendingUpdates.remove(removed);
        for (Resource resource : model.listSubjects().toSet()) {
            if (this.negCache.contains((Object)resource)) {
                this.negCache.remove((Object)resource);
                Resource rem = (Resource)this.posCache.addAndGetRemoved((Object)resource);
                this.cacheData.remove(rem, null, (RDFNode)null);
            }
            if (!this.posCache.contains((Object)resource)) continue;
            this.cacheData.add(removed.listStatements(resource, null, (RDFNode)null));
        }
    }

    public void applyChanges() throws Exception {
        this.graphDAO.remove((Model)this.pendingUpdates.getRemoved(), this.graphName);
        this.graphDAO.insert((Model)this.pendingUpdates.getAdded(), this.graphName);
    }

    private static Model lookupBySubject(SparqlEndpoint graphDAO, Collection<Resource> subjects, String graphName, int batchSize) throws Exception {
        Model result = ModelFactory.createDefaultModel();
        List chunks = CollectionUtils.chunk(subjects, (int)batchSize);
        for (List chunk : chunks) {
            String resources = "<" + Joiner.on((String)">,<").join((Iterable)chunk) + ">";
            String fromPart = graphName != null ? "From <" + graphName + "> " : "";
            String query = "Construct { ?s ?p ?o . } " + fromPart + "{ ?s ?p ?o . Filter(?s In (" + resources + ")) . }";
            Model tmp = graphDAO.executeConstruct(query);
            result.add(tmp);
        }
        return result;
    }

    public static String myToString(Collection<?> collection) {
        return "(" + collection.size() + ")" + collection;
    }

    public static Set<List<Object>> toKeys(Collection<Resource> resources) {
        HashSet<List<Object>> result = new HashSet<List<Object>>();
        for (Resource item : resources) {
            result.add(Collections.singletonList(item.asNode()));
        }
        return result;
    }
}

