/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.commons.graph;

import com.hp.hpl.jena.graph.Triple;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.aksw.commons.graph.BaseIndexedGraph;
import org.aksw.commons.graph.IGraph;
import org.aksw.commons.graph.MemoryGraph;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DeltaGraph
extends BaseIndexedGraph {
    private static final Logger logger = LoggerFactory.getLogger(DeltaGraph.class);
    private IGraph baseGraph;
    private IGraph additionGraph = new MemoryGraph();
    private IGraph removalGraph = new MemoryGraph();

    public DeltaGraph(IGraph baseGraph) {
        this.baseGraph = baseGraph;
    }

    public void commit() {
        Set<Triple> r = this.removalGraph.bulkFind(null, new int[0]);
        Set<Triple> a = this.additionGraph.bulkFind(null, new int[0]);
        logger.info("Committing " + a.size() + "/" + r.size() + " added/removed triples");
        System.out.println("Removed: " + r);
        System.out.println("Added: " + a);
        this.baseGraph.remove(r);
        this.baseGraph.add(a);
        this.removalGraph.clear();
        this.additionGraph.clear();
    }

    public void addTriple(Triple triple) {
        this.removalGraph.remove(Collections.singleton(triple));
        this.additionGraph.add(Collections.singleton(triple));
    }

    public void removeTriple(Triple triple) {
        this.additionGraph.remove(Collections.singleton(triple));
        this.removalGraph.add(Collections.singleton(triple));
    }

    public IGraph getBaseGraph() {
        return this.baseGraph;
    }

    public IGraph getAdditionGraph() {
        return this.additionGraph;
    }

    public IGraph getRemovalGraph() {
        return this.removalGraph;
    }

    @Override
    public void add(Collection<Triple> triples) {
        for (Triple triple : triples) {
            this.addTriple(triple);
        }
    }

    @Override
    public void remove(Collection<Triple> triples) {
        for (Triple triple : triples) {
            this.removeTriple(triple);
        }
    }

    @Override
    public Set<Triple> uncachedBulkFind(Set<List<Object>> keys, int[] indexColumns) {
        Set<Triple> addTriples = this.additionGraph.bulkFind(keys, indexColumns);
        Set<Triple> removalTriples = this.removalGraph.bulkFind(keys, indexColumns);
        Set<Triple> result = this.baseGraph.bulkFind(keys, indexColumns);
        result.removeAll(removalTriples);
        result.addAll(addTriples);
        return result;
    }

    @Override
    public void clear() {
        this.additionGraph.clear();
        this.removalGraph.clear();
        this.baseGraph.clear();
    }
}

