/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.commons.graph;

import com.google.common.base.Joiner;
import com.hp.hpl.jena.rdf.model.Literal;
import com.hp.hpl.jena.rdf.model.Resource;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.aksw.commons.collections.FlatMapView;
import org.aksw.commons.graph.IFilterCompiler;

class DefaultFilterCompilerModel
implements IFilterCompiler {
    DefaultFilterCompilerModel() {
    }

    @Override
    public List<String> compileFilter(Collection<List<Object>> keys, List<String> columnNames) {
        ArrayList<String> result = new ArrayList<String>();
        if (columnNames.size() == 1) {
            String columnName = columnNames.get(0);
            HashSet remaining = new HashSet(new FlatMapView(keys));
            HashSet<Resource> resources = new HashSet<Resource>();
            Iterator it = remaining.iterator();
            while (it.hasNext()) {
                Object current = it.next();
                if (current instanceof Resource) {
                    resources.add((Resource)current);
                }
                it.remove();
            }
            String inPart = Joiner.on((String)">,<").join(resources);
            if (!inPart.isEmpty()) {
                result.add(columnName + " In (<" + inPart + ">)");
            }
            for (Resource resource : resources) {
                remaining.remove(resource);
            }
            for (Object o : remaining) {
                result.add(this.compileFilter(o, columnName));
            }
        } else {
            for (List<Object> key : keys) {
                String part = "";
                for (int i = 0; i < key.size(); ++i) {
                    if (!part.isEmpty()) {
                        part = part + " &&";
                    }
                    part = part + this.compileFilter(key.get(i), columnNames.get(i));
                }
                result.add(part);
            }
        }
        return result;
    }

    private String compileFilter(Object o, String columnName) {
        if (o instanceof Resource) {
            return columnName + " = <" + o + ">";
        }
        if (o instanceof Literal) {
            Literal l = (Literal)o;
            String result = "str(" + columnName + ") = \"" + l.getLexicalForm() + "\"";
            if (!l.getLanguage().isEmpty()) {
                result = result + "&& langMatches(lang(" + columnName + "), " + l.getLanguage() + ")";
            } else if (l.getDatatype() == null) {
                result = result + "&& datatype(" + columnName + ") = <" + l.getDatatypeURI() + ">";
            }
            return result;
        }
        throw new RuntimeException("Should never come here - maybe a blank node of evilness?");
    }
}

