/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.commons.graph;

import com.hp.hpl.jena.graph.Triple;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.aksw.commons.graph.DefaultCacheProvider;
import org.aksw.commons.graph.ICacheProvider;
import org.aksw.commons.graph.IGraph;
import org.aksw.commons.graph.IGraphListener;

public abstract class BaseIndexedGraph
implements IGraph {
    protected List<IGraphListener> listeners = new ArrayList<IGraphListener>();
    protected ICacheProvider cacheProvider = new DefaultCacheProvider(this);

    protected BaseIndexedGraph() {
    }

    @Override
    public Collection<IGraphListener> getGraphListeners() {
        return this.listeners;
    }

    @Override
    public ICacheProvider getCacheProvider() {
        return this.cacheProvider;
    }

    @Override
    public Set<Triple> bulkFind(Set<List<Object>> keys, int[] indexColumns) {
        return this.cacheProvider == null ? this.uncachedBulkFind(keys, indexColumns) : this.cacheProvider.bulkFind(keys, indexColumns);
    }

    @Override
    public void add(Collection<Triple> triples) {
        for (IGraphListener listener : this.listeners) {
            listener.onAdd(this, triples);
        }
    }

    @Override
    public void remove(Collection<Triple> triples) {
        for (IGraphListener listener : this.listeners) {
            listener.onRemove(this, triples);
        }
    }

    public String toString() {
        return "Index Status:\n" + this.getCacheProvider().toString();
    }
}

