/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.commons.owlapi;

import com.jamonapi.Monitor;
import com.jamonapi.MonitorFactory;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.util.Map;
import org.aksw.commons.util.Time;
import org.coode.owlapi.manchesterowlsyntax.ManchesterOWLSyntaxOntologyFormat;
import org.coode.owlapi.turtle.TurtleOntologyFormat;
import org.semanticweb.owlapi.io.RDFXMLOntologyFormat;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyFormat;
import org.semanticweb.owlapi.model.OWLOntologyStorageException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StringConverter {
    private static final Logger logger = LoggerFactory.getLogger(StringConverter.class);
    private final OWLOntology ontology;

    public StringConverter(OWLOntology ontology) {
        this.ontology = ontology;
    }

    public String toString() {
        return this.toStringAsTurtle();
    }

    public String toStringAsTurtle() {
        return this.toString((OWLOntologyFormat)new TurtleOntologyFormat());
    }

    public String toStringAsRDFXML() {
        return this.toString((OWLOntologyFormat)new RDFXMLOntologyFormat());
    }

    public String toStringAsManchesterOWLSyntax() {
        return this.toString((OWLOntologyFormat)new ManchesterOWLSyntaxOntologyFormat());
    }

    public String toStringAsManchesterOWLSyntax(Map<String, String> prefixToNamespaceMap) {
        ManchesterOWLSyntaxOntologyFormat format = new ManchesterOWLSyntaxOntologyFormat();
        for (String key : prefixToNamespaceMap.keySet()) {
            String value = prefixToNamespaceMap.get(key);
            format.setPrefix(value, key);
        }
        String ret = this.toString((OWLOntologyFormat)format);
        return ret;
    }

    public String toString(OWLOntologyFormat format) {
        Monitor m = MonitorFactory.getTimeMonitor((String)(StringConverter.class.getCanonicalName() + "toString")).start();
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            this.ontology.getOWLOntologyManager().saveOntology(this.ontology, format, (OutputStream)baos);
        }
        catch (OWLOntologyStorageException e) {
            m.stop();
            logger.error("Could not convert ontology to string" + format.toString(), (Throwable)e);
        }
        String ret = baos.toString();
        logger.debug("Conversion of OWLAPI to " + format.toString() + " finished [" + ret.length() + " chars] " + Time.neededMs((double)m.stop().getLastValue()));
        return ret;
    }

    public String toStringHumanReadable(Map<String, String> prefixMap) {
        String mos = this.toStringAsManchesterOWLSyntax(prefixMap);
        mos = mos.replaceAll("\n\n", "\n").replaceAll("\n\n", "\n");
        StringBuffer buffer = new StringBuffer();
        for (String m : mos.split("\n")) {
            String current = m.trim();
            if (current.length() == 0 || m.startsWith("Prefix:")) continue;
            buffer.append(m);
            buffer.append("\n");
        }
        mos = buffer.toString();
        return mos;
    }
}

