/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.commons.owlapi;

import com.jamonapi.Monitor;
import com.jamonapi.MonitorFactory;
import java.io.File;
import org.aksw.commons.util.Time;
import org.coode.owlapi.turtle.TurtleOntologyFormat;
import org.semanticweb.owlapi.io.RDFXMLOntologyFormat;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyFormat;
import org.semanticweb.owlapi.model.OWLOntologyStorageException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SaveOntology {
    private static final Logger logger = LoggerFactory.getLogger(SaveOntology.class);

    public static void saveOntologyAsRDFXML(OWLOntology ontology, String toFile) {
        SaveOntology.saveOntology(ontology, (OWLOntologyFormat)new RDFXMLOntologyFormat(), IRI.create((File)new File(toFile)));
    }

    public static void saveOntologyAsTurtle(OWLOntology ontology, File toFile) {
        SaveOntology.saveOntology(ontology, (OWLOntologyFormat)new TurtleOntologyFormat(), IRI.create((File)toFile));
    }

    public static void saveOntology(OWLOntology ontology, OWLOntologyFormat format, IRI targetIRI) {
        Monitor m = MonitorFactory.getTimeMonitor((String)(SaveOntology.class.getCanonicalName() + "saveOntology")).start();
        try {
            ontology.getOWLOntologyManager().saveOntology(ontology, format, targetIRI);
        }
        catch (OWLOntologyStorageException e) {
            m.stop();
            logger.error("Could not save ontology to " + targetIRI, (Throwable)e);
        }
        logger.debug("Saving as " + format.toString() + " finished " + Time.neededMs((double)m.stop().getLastValue()));
    }
}

