/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.commons.jena_owlapi;

import com.hp.hpl.jena.ontology.OntModel;
import com.hp.hpl.jena.ontology.OntModelSpec;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.lang.reflect.Field;
import java.util.Set;
import org.aksw.commons.jena.Constants;
import org.aksw.commons.jena.StringConverter;
import org.coode.owlapi.rdf.model.RDFGraph;
import org.coode.owlapi.rdf.model.RDFLiteralNode;
import org.coode.owlapi.rdf.model.RDFNode;
import org.coode.owlapi.rdf.model.RDFTriple;
import org.semanticweb.owlapi.apibinding.OWLManager;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyCreationException;
import org.semanticweb.owlapi.model.OWLOntologyManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Conversion {
    private static final Logger logger = LoggerFactory.getLogger(Conversion.class);

    public static OWLOntology JenaModel2OWLAPIOntology(Model m) {
        String rdfxml = new StringConverter(m).toStringAsRDFXML();
        ByteArrayInputStream bs = new ByteArrayInputStream(rdfxml.getBytes());
        OWLOntologyManager manager = OWLManager.createOWLOntologyManager();
        OWLOntology retOnt = null;
        try {
            retOnt = manager.loadOntologyFromOntologyDocument((InputStream)bs);
        }
        catch (OWLOntologyCreationException e) {
            logger.error("could not create ontology ", (Throwable)e);
        }
        return retOnt;
    }

    public static OntModel OWLAPIOntology2JenaOntModel(OWLOntology ontology) {
        OntModel m = ModelFactory.createOntologyModel((OntModelSpec)OntModelSpec.OWL_DL_MEM);
        return (OntModel)Conversion.OWLAPIOntology2JenaModel(ontology, (Model)m);
    }

    public static Model OWLAPIOntology2JenaModel(OWLOntology ontology, Model resultModel) {
        String rdfxml = new org.aksw.commons.owlapi.StringConverter(ontology).toStringAsRDFXML();
        ByteArrayInputStream bs = new ByteArrayInputStream(rdfxml.getBytes());
        resultModel.read((InputStream)bs, "", Constants.RDFXML);
        return resultModel;
    }

    public static Set<RDFTriple> extractTriples(RDFGraph graph) {
        Field field = null;
        try {
            field = graph.getClass().getDeclaredField("triples");
            boolean saved = field.isAccessible();
            field.setAccessible(true);
            Set triples = (Set)field.get(graph);
            field.setAccessible(saved);
            return triples;
        }
        catch (Exception e) {
            throw new RuntimeException("Should not happen", e);
        }
    }

    public static String toStringNTriples(RDFGraph graph) {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        Conversion.writeNTriples(graph, out);
        return out.toString();
    }

    public static void writeNTriples(RDFGraph graph, OutputStream out) {
        Conversion.writeNTriples(graph, new PrintStream(out));
    }

    public static void writeNTriples(RDFGraph graph, PrintStream out) {
        Set<RDFTriple> triples = Conversion.extractTriples(graph);
        for (RDFTriple triple : triples) {
            out.println(Conversion.toStringNTriples(triple));
        }
    }

    public static String toStringNTriples(RDFTriple triple) {
        return Conversion.toStringSparql(triple) + " .";
    }

    public static String toStringSparql(RDFTriple triple) {
        return Conversion.toString((RDFNode)triple.getSubject()) + " " + Conversion.toString((RDFNode)triple.getProperty()) + " " + Conversion.toString(triple.getObject());
    }

    public static String toString(RDFNode node) {
        if (node.isAnonymous()) {
            return "_:a" + node.toString();
        }
        if (node.isLiteral()) {
            RDFLiteralNode n = (RDFLiteralNode)node;
            String literal = Conversion.sparqlEscapeLiteral(n.getLiteral());
            String result = "\"\"\"" + literal + "\"\"\"";
            if (n.getLang() != null && !n.getLang().isEmpty()) {
                result = result + "@" + n.getLang().toLowerCase();
            }
            if (n.getDatatype() != null) {
                result = result + "^^<" + n.getDatatype() + ">";
            }
            return result;
        }
        return node.toString();
    }

    public static String sparqlEscapeLiteral(String literal) {
        return literal.replace("\"", "\\\"");
    }
}

