/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.commons.jena.impl;

import com.hp.hpl.jena.ontology.OntModel;
import com.hp.hpl.jena.ontology.OntModelSpec;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import java.util.HashSet;
import org.aksw.commons.jena.OntologyLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpleLoader
implements OntologyLoader {
    private static final Logger log = LoggerFactory.getLogger(SimpleLoader.class);

    @Override
    public OntModel loadOntology(String ontologyUri) {
        OntModel model = ModelFactory.createOntologyModel((OntModelSpec)OntModelSpec.OWL_DL_MEM, (Model)ModelFactory.createDefaultModel());
        model.read(ontologyUri);
        return model;
    }

    @Override
    public void loadImports(OntModel m) {
        HashSet<String> loaded = new HashSet<String>();
        for (String one : m.listImportedOntologyURIs()) {
            if (!loaded.add(one)) {
                log.debug("skipping " + one + " (already load)");
                continue;
            }
            OntModel sm = this.loadOntology(one);
            this.loadImports(sm);
            m.addSubModel((Model)sm);
        }
    }
}

