/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.commons.jena;

import com.hp.hpl.jena.ontology.OntModel;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.RDFWriter;
import com.jamonapi.Monitor;
import com.jamonapi.MonitorFactory;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import org.aksw.commons.jena.Constants;
import org.aksw.commons.util.ExtendedFile;
import org.aksw.commons.util.Time;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated
public class StringConverter {
    private static final Logger logger = LoggerFactory.getLogger(StringConverter.class);
    private final Model model;
    private boolean useProperStringSerialization = true;
    private boolean outputInferredModel = false;

    public StringConverter(Model m) {
        this.model = m;
        if (this.model == null) {
            logger.warn("inserted Model was null");
        }
        if (this.model.size() == 0L) {
            logger.warn("inserted Model was empty");
        }
    }

    public void setUseProperStringSerialization(boolean useProperStringSerialization) {
        this.useProperStringSerialization = useProperStringSerialization;
    }

    public void setOutputInferredModel(boolean outputInferredModel) {
        this.outputInferredModel = outputInferredModel;
    }

    public String toString() {
        return this.toStringAsTurtle();
    }

    public String toStringAsTurtle() {
        return this.toString(Constants.TURTLE);
    }

    public String toStringAsRDFXML() {
        return this.toString(Constants.RDFXML);
    }

    public String toStringAsNTriple() {
        return this.toString(Constants.N_TRIPLE);
    }

    public String toString(String format) {
        Monitor monitor = MonitorFactory.getTimeMonitor((String)(StringConverter.class.getSimpleName() + "toString")).start();
        String ret = this.useProperStringSerialization ? this.toStringProper(format) : this.toStringAlternate(format);
        logger.debug("Conversion of Jena to " + format + " finished [" + ret.length() + " chars] " + Time.neededMs((double)monitor.stop().getLastValue()));
        return ret;
    }

    public String toStringAlternate(String format) {
        String ret = "";
        String tmpfilename = "";
        try {
            File f = File.createTempFile("JenaTaskstoStringAlternate", null);
            tmpfilename = f.toString();
            this.model.write((Writer)new FileWriter(f), format);
            ret = new ExtendedFile(f).readContent();
            f.delete();
        }
        catch (IOException e) {
            logger.error("tmp file was: " + tmpfilename, (Throwable)e);
        }
        return ret;
    }

    public String toStringProper(String format) {
        Model convert = this.model;
        if (this.model instanceof OntModel && !this.outputInferredModel) {
            convert = ((OntModel)this.model).getRawModel();
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        RDFWriter writer = convert.getWriter(format);
        writer.write(convert, (OutputStream)baos, "");
        return baos.toString();
    }
}

