/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.commons.jena;

import com.hp.hpl.jena.rdf.model.Literal;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.RDFErrorHandler;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.RDFWriter;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.Statement;
import com.hp.hpl.jena.rdf.model.StmtIterator;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import org.aksw.commons.jena.ModelUtils;
import org.aksw.commons.jena.RDFNodePrettyComparator;
import org.apache.commons.lang.StringEscapeUtils;

public class RDFWriterHtml
implements RDFWriter {
    String nodeToString(RDFNode node, NavigableMap<String, String> nsToPrefix, String attributes) {
        if (node.isURIResource()) {
            String uri = ((Resource)node.as(Resource.class)).getURI();
            String prettyURI = ModelUtils.prettyUri(uri, nsToPrefix);
            return "<a href='" + uri + "' " + attributes + ">" + StringEscapeUtils.escapeHtml((String)prettyURI) + "</a>";
        }
        if (node.isLiteral()) {
            Literal literal = (Literal)node.as(Literal.class);
            String valuePart = literal.getValue().toString();
            String suffixPart = literal.getDatatype() != null ? "^^" + ModelUtils.prettyUri(literal.getDatatypeURI(), nsToPrefix) : (literal.getLanguage().isEmpty() ? "" : "@" + literal.getLanguage());
            String result = StringEscapeUtils.escapeHtml((String)(valuePart + suffixPart));
            return result;
        }
        if (node.isAnon()) {
            return StringEscapeUtils.escapeHtml((String)node.toString());
        }
        throw new RuntimeException("Should not happen");
    }

    public void write(Model model, Writer out, String base) {
        try {
            this._write(model, out, base);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void _write(Model model, Writer out, String base) throws IOException {
        Map prefixToNs = model.getNsPrefixMap();
        TreeMap<String, String> nsToPrefix = new TreeMap<String, String>();
        for (Map.Entry item : prefixToNs.entrySet()) {
            nsToPrefix.put((String)item.getValue(), (String)item.getKey());
        }
        RDFNodePrettyComparator comp = new RDFNodePrettyComparator();
        StmtIterator itStmt = model.listStatements();
        TreeMap spo = new TreeMap(comp);
        while (itStmt.hasNext()) {
            TreeSet<RDFNode> p;
            Statement stmt = (Statement)itStmt.next();
            TreeMap<RDFNode, TreeSet<RDFNode>> po = (TreeMap<RDFNode, TreeSet<RDFNode>>)spo.get(stmt.getSubject());
            if (po == null) {
                po = new TreeMap<RDFNode, TreeSet<RDFNode>>(comp);
                spo.put((RDFNode)stmt.getSubject(), po);
            }
            if ((p = (TreeSet<RDFNode>)po.get(stmt.getPredicate())) == null) {
                p = new TreeSet<RDFNode>(comp);
                po.put((RDFNode)stmt.getPredicate(), p);
            }
            p.add(stmt.getObject());
        }
        itStmt.close();
        boolean isOdd = true;
        out.write("<table class='properties'>\n");
        for (Map.Entry s2po : spo.entrySet()) {
            RDFNode subject = (RDFNode)s2po.getKey();
            out.write("<tr><td colspan='2'>" + this.nodeToString(subject, nsToPrefix, "class='heading'") + "</td></tr>\n");
            for (Map.Entry p2o : ((Map)s2po.getValue()).entrySet()) {
                RDFNode predicate = (RDFNode)p2o.getKey();
                String predField = this.nodeToString(predicate, nsToPrefix, "class='content'");
                for (RDFNode o : (Set)p2o.getValue()) {
                    String cssClass = isOdd ? "odd" : "even";
                    isOdd = !isOdd;
                    out.write("<tr class = '" + cssClass + "'><td style='padding-right:5em;'> " + predField + "</td><td style='width:100%;'>" + this.nodeToString(o, nsToPrefix, "class='content'") + "</td></tr>\n");
                    predField = "";
                }
            }
            out.write("<tr class='even'><td colspan='2'>&nbsp;</td></tr>\n");
        }
        out.write("<table>\n");
        out.flush();
    }

    public void write(Model model, OutputStream out, String base) {
        this.write(model, new PrintWriter(out), base);
    }

    public Object setProperty(String propName, Object propValue) {
        return null;
    }

    public RDFErrorHandler setErrorHandler(RDFErrorHandler errHandler) {
        return null;
    }
}

