/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.commons.jena;

import com.hp.hpl.jena.rdf.model.Literal;
import com.hp.hpl.jena.rdf.model.RDFNode;
import java.util.Comparator;
import org.aksw.commons.util.strings.StringPrettyComparator;

public class RDFNodePrettyComparator
implements Comparator<RDFNode> {
    private StringPrettyComparator stringComparator = new StringPrettyComparator();

    int getTypeSortValue(RDFNode node) {
        if (node.isURIResource()) {
            return 0;
        }
        if (node.isLiteral()) {
            return 1;
        }
        if (node.isAnon()) {
            return 2;
        }
        throw new RuntimeException("Shouldn't happen");
    }

    public int compareLiteral(Literal a, Literal b) {
        int tA = a.getDatatype() == null ? -1 : 0;
        int tB = b.getDatatype() == null ? 1 : 0;
        int d = tB + tA;
        if (d != 0) {
            return d;
        }
        if (a.getDatatype() != null) {
            d = this.stringComparator.compare(a.getDatatypeURI(), b.getDatatypeURI());
            if (d != 0) {
                return d;
            }
            return this.stringComparator.compare(a.getValue().toString(), b.getValue().toString());
        }
        d = a.getLanguage().compareTo(b.getLanguage());
        if (d != 0) {
            return d;
        }
        return this.stringComparator.compare(a.getValue().toString(), b.getValue().toString());
    }

    @Override
    public int compare(RDFNode a, RDFNode b) {
        int tA = this.getTypeSortValue(a);
        int tB = this.getTypeSortValue(b);
        int d = tB - tA;
        if (d != 0) {
            return d;
        }
        if (a.isURIResource()) {
            return this.stringComparator.compare(a.asNode().getURI(), b.asNode().getURI());
        }
        if (a.isLiteral()) {
            return this.compareLiteral((Literal)a.as(Literal.class), (Literal)b.as(Literal.class));
        }
        if (a.isAnon()) {
            return this.stringComparator.compare(a.asNode().getBlankNodeLabel(), b.asNode().getBlankNodeLabel());
        }
        throw new RuntimeException("Shouldn't happen");
    }
}

