/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.commons.jena;

import com.hp.hpl.jena.ontology.OntClass;
import com.hp.hpl.jena.ontology.OntModel;
import com.hp.hpl.jena.ontology.OntModelSpec;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.Resource;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClassIndexer {
    private static Logger log = LoggerFactory.getLogger(ClassIndexer.class);
    private boolean copyLabels = true;
    private boolean copyComments = true;
    private String language = null;
    private Map<String, String> transform = new HashMap<String, String>();
    private Set<String> remove = new HashSet<String>();
    private Map<String, OntModel> classUriToClassHierarchy = new HashMap<String, OntModel>();

    public void index(OntModel from) {
        Set classes = from.listClasses().toSet();
        boolean i = false;
        for (OntClass cl : classes) {
            Tree t = new Tree(cl);
            this.classUriToClassHierarchy.put(cl.getURI(), t.toModel());
        }
    }

    public OntModel getHierarchyForClassURI(String classUri) {
        return this.classUriToClassHierarchy.get(classUri);
    }

    private String transformNamespace(String in) {
        String ret = in;
        for (String s : this.transform.keySet()) {
            if (!in.startsWith(s)) continue;
            return in.replace(s, this.transform.get(s));
        }
        return ret;
    }

    private boolean filterNamespace(String s) {
        for (String prefix : this.remove) {
            if (!s.startsWith(prefix)) continue;
            return true;
        }
        return false;
    }

    public boolean isCopyLabels() {
        return this.copyLabels;
    }

    public void setCopyLabels(boolean copyLabels) {
        this.copyLabels = copyLabels;
    }

    public boolean isCopyComments() {
        return this.copyComments;
    }

    public void setCopyComments(boolean copyComments) {
        this.copyComments = copyComments;
    }

    public String getLanguage() {
        return this.language;
    }

    public void setLanguage(String language) {
        this.language = language;
    }

    private class Tree {
        final String uri;
        List<Tree> parents;
        final String label;
        final String comment;

        public Tree(OntClass me) {
            this.uri = me.getURI();
            this.label = me.getLabel(ClassIndexer.this.language);
            this.comment = me.getComment(ClassIndexer.this.language);
            this.parents = new ArrayList<Tree>();
            Set superClasses = me.listSuperClasses(true).toSet();
            for (OntClass s : superClasses) {
                if (s.isAnon()) continue;
                log.trace(s.toString());
                this.parents.add(new Tree(s));
            }
        }

        public OntModel toModel() {
            OntModel model = ModelFactory.createOntologyModel((OntModelSpec)OntModelSpec.OWL_DL_MEM, (Model)ModelFactory.createDefaultModel());
            OntClass me = model.createClass(this.uri);
            if (ClassIndexer.this.copyLabels && this.label != null) {
                me.addLabel(this.label, ClassIndexer.this.language);
            }
            if (ClassIndexer.this.copyComments && this.comment != null) {
                me.addComment(this.comment, ClassIndexer.this.language);
            }
            for (Tree p : this.parents) {
                OntClass superClass = model.createClass(p.uri);
                me.addSuperClass((Resource)superClass);
                model.add((Model)p.toModel());
            }
            return model;
        }
    }
}

