/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.commons.graph;

import com.google.common.base.Joiner;
import com.hp.hpl.jena.graph.Node;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.aksw.commons.collections.FlatMapView;
import org.aksw.commons.graph.IFilterCompiler;

public class DefaultFilterCompiler
implements IFilterCompiler {
    @Override
    public List<String> compileFilter(Collection<List<Object>> keys, List<String> columnNames) {
        ArrayList<String> result = new ArrayList<String>();
        if (columnNames.isEmpty()) {
            return result;
        }
        if (columnNames.size() == -1) {
            String columnName = columnNames.get(0);
            HashSet remaining = new HashSet(new FlatMapView(keys));
            HashSet<Node> resources = new HashSet<Node>();
            Iterator it = remaining.iterator();
            while (it.hasNext()) {
                Node node;
                Object current = it.next();
                if (current instanceof Node && (node = (Node)current).isURI()) {
                    resources.add(node);
                }
                it.remove();
            }
            String inPart = Joiner.on((String)">,<").join(resources);
            if (!inPart.isEmpty()) {
                result.add(columnName + " In (<" + inPart + ">)");
            }
            for (Node resource : resources) {
                remaining.remove(resource);
            }
            for (Object o : remaining) {
                result.add(this.compileFilter((Node)o, columnName));
            }
        } else {
            for (List<Object> key : keys) {
                String part = "";
                for (int i = 0; i < key.size(); ++i) {
                    if (!part.isEmpty()) {
                        part = part + " &&";
                    }
                    part = part + this.compileFilter((Node)key.get(i), columnNames.get(i));
                }
                result.add(part);
            }
        }
        return result;
    }

    private String compileFilter(Node node, String columnName) {
        if (node.isURI()) {
            return columnName + " = <" + node.getURI() + ">";
        }
        if (node.isLiteral()) {
            String result = "str(" + columnName + ") = \"" + node.getLiteralLexicalForm() + "\"";
            if (!node.getLiteralLanguage().isEmpty()) {
                result = result + "&& langMatches(lang(" + columnName + "), " + node.getLiteralLanguage() + ")";
            } else if (node.getLiteralDatatype() == null) {
                result = result + "&& datatype(" + columnName + ") = <" + node.getLiteralDatatypeURI() + ">";
            }
            return result;
        }
        throw new RuntimeException("Should never come here - maybe a blank node of evilness?");
    }
}

