/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.commons.graph;

import com.hp.hpl.jena.graph.Triple;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.aksw.commons.graph.ICacheProvider;
import org.aksw.commons.graph.IGraph;
import org.aksw.commons.graph.IGraphListener;
import org.aksw.commons.graph.ITripleCacheIndex;
import org.aksw.commons.graph.IndexCompatibilityLevel;
import org.aksw.commons.graph.TripleIndexUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultCacheProvider
implements ICacheProvider,
IGraphListener {
    private static final Logger logger = LoggerFactory.getLogger(DefaultCacheProvider.class);
    private IGraph graph;
    private Set<ITripleCacheIndex> tripleCacheIndexes = new HashSet<ITripleCacheIndex>();

    public DefaultCacheProvider(IGraph graph) {
        this.graph = graph;
        graph.getGraphListeners().add(this);
    }

    @Override
    public void clear() {
        for (ITripleCacheIndex index : this.tripleCacheIndexes) {
            index.clear();
        }
    }

    @Override
    public Set<Triple> bulkFind(Set<List<Object>> keys, int[] indexColumns) {
        if (keys == null) {
            keys = Collections.emptySet();
        }
        HashSet<ITripleCacheIndex> fullIndexes = new HashSet<ITripleCacheIndex>();
        HashSet<ITripleCacheIndex> partialIndexes = new HashSet<ITripleCacheIndex>();
        for (ITripleCacheIndex index : this.tripleCacheIndexes) {
            IndexCompatibilityLevel level = index.getCompatibilityLevel(indexColumns);
            if (level.equals((Object)IndexCompatibilityLevel.FULL)) {
                fullIndexes.add(index);
                continue;
            }
            if (!level.equals((Object)IndexCompatibilityLevel.PARTIAL)) continue;
            partialIndexes.add(index);
        }
        HashSet<Triple> result = new HashSet<Triple>();
        HashSet<List<Object>> remaining = new HashSet<List<Object>>(keys);
        Iterator it = remaining.iterator();
        block1: while (it.hasNext()) {
            List key = (List)it.next();
            for (ITripleCacheIndex index : fullIndexes) {
                Collection<Triple> triples = index.lookup(key);
                if (triples == null) continue;
                result.addAll(triples);
                it.remove();
                continue block1;
            }
        }
        Set<Triple> furtherTriples = this.graph.uncachedBulkFind(remaining, indexColumns);
        for (Triple triple : furtherTriples) {
            List<Object> l = TripleIndexUtils.tripleToList(triple, indexColumns);
            if (!remaining.contains(l)) continue;
            remaining.remove(l);
        }
        for (ITripleCacheIndex index : fullIndexes) {
            index.registerMisses(remaining);
            index.index(furtherTriples);
        }
        for (ITripleCacheIndex index : partialIndexes) {
            index.registerMisses(remaining);
            index.addSeen(furtherTriples);
        }
        result.addAll(furtherTriples);
        return result;
    }

    @Override
    public void addSeen(Collection<Triple> triples) {
        for (ITripleCacheIndex index : this.tripleCacheIndexes) {
            index.addSeen(triples);
        }
    }

    @Override
    public void removeSeen(Collection<Triple> triples) {
        for (ITripleCacheIndex index : this.tripleCacheIndexes) {
            index.removeSeen(triples);
        }
    }

    @Override
    public IGraph getGraph() {
        return this.graph;
    }

    @Override
    public Collection<ITripleCacheIndex> getIndexes() {
        return this.tripleCacheIndexes;
    }

    public String toString() {
        String result = "";
        for (ITripleCacheIndex index : this.tripleCacheIndexes) {
            result = result + index.toString() + "\n";
        }
        return result;
    }

    @Override
    public void onAdd(IGraph g, Collection<Triple> triples) {
        this.addSeen(triples);
    }

    @Override
    public void onRemove(IGraph g, Collection<Triple> triples) {
        this.removeSeen(triples);
    }
}

