/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.commons.experiments;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.SortedSet;
import java.util.TreeSet;
import org.aksw.commons.experiments.TableRowColumn;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Table
implements Serializable {
    private static final Logger logger = LoggerFactory.getLogger(Table.class);
    private SortedSet<String> experimentNames = new TreeSet<String>();
    private SortedSet<String> labels = new TreeSet<String>();
    private int length = 0;
    private List<TableRowColumn> tableRowColumns = new ArrayList<TableRowColumn>();

    public List<TableRowColumn> getTableRowColumns() {
        return this.tableRowColumns;
    }

    public int size() {
        return this.length;
    }

    public void addTable(Table t) {
        for (TableRowColumn trc : t.tableRowColumns) {
            this.addTableRowColumn(trc);
        }
    }

    public void addTableRowColumns(List<TableRowColumn> trcs) {
        for (TableRowColumn tableRowColumn : trcs) {
            this.addTableRowColumn(tableRowColumn);
        }
    }

    public void addTableRowColumn(TableRowColumn trc) {
        this.labels.add(trc.getLabel());
        this.experimentNames.add(trc.getExperimentName());
        if (this.tableRowColumns.isEmpty()) {
            this.length = trc.size();
        }
        if (trc.size() != this.length) {
            logger.error("Added TableRowColumn does not match previous set length (" + this.length + ") but has size " + trc.size() + "), \nignoring it: " + trc);
        }
        this.tableRowColumns.add(trc);
    }
}

