/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.commons.experiments;

import com.jamonapi.MonKey;
import com.jamonapi.MonKeyImp;
import com.jamonapi.Monitor;
import com.jamonapi.MonitorFactory;
import java.util.HashMap;
import java.util.Map;
import org.aksw.commons.experiments.Static;
import org.aksw.commons.experiments.Table;
import org.aksw.commons.experiments.TableRowColumn;

public class ExperimentStatisticsCollector {
    private final String experimentName;
    private final int nrOfIterations;
    private final Map<String, Static.Units> map = new HashMap<String, Static.Units>();

    public ExperimentStatisticsCollector(String experimentName, int nrOfIterations) {
        this.experimentName = experimentName;
        this.nrOfIterations = nrOfIterations;
    }

    public Monitor getMonitor(String label, int iteration, Static.Units unit) {
        this.map.put(label, unit);
        return MonitorFactory.getMonitor((MonKey)this.makeMonKey(label, iteration, unit));
    }

    public TableRowColumn getTableColumnRow(String label, Static.Units unit) {
        Monitor[] m = new Monitor[this.nrOfIterations];
        for (int i = 0; i < this.nrOfIterations; ++i) {
            m[i] = this.getMonitor(label, i, unit);
        }
        TableRowColumn trc = new TableRowColumn(this.experimentName, label, unit, m);
        trc.finalize();
        return trc;
    }

    public Table getTable() {
        Table t = new Table();
        for (String label : this.map.keySet()) {
            Static.Units u = this.map.get(label);
            t.addTableRowColumn(this.getTableColumnRow(label, u));
        }
        return t;
    }

    private String makeMonitorLabel(String label, int i) {
        return this.makeMonitorLabel(label) + "_" + i;
    }

    private String makeMonitorLabel(String label) {
        return this.experimentName + "_" + label;
    }

    private MonKeyImp makeMonKey(String label, Static.Units unit) {
        return new MonKeyImp(this.makeMonitorLabel(label), Static.getUnitString(unit));
    }

    private MonKeyImp makeMonKey(String label, int i, Static.Units unit) {
        return new MonKeyImp(this.makeMonitorLabel(label, i), Static.getUnitString(unit));
    }
}

