/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.commons.experiments.impl;

import java.util.List;
import org.aksw.commons.experiments.FinalizedMonitor;
import org.aksw.commons.experiments.Table;
import org.aksw.commons.experiments.TableFormatter;
import org.aksw.commons.experiments.TableRowColumn;

public class LatexRowFormatter
implements TableFormatter {
    public static String latexSep = "\t&\t";
    public static String latexEnd = "\\\\";
    boolean replaceCommaByPoints = true;

    @Override
    public String format(Table table) {
        List<TableRowColumn> tableRowColumns = table.getTableRowColumns();
        String ret = "";
        for (TableRowColumn trc : tableRowColumns) {
            ret = ret + this.toRow(trc) + "\n";
        }
        return this.replaceCommaByPoints ? ret.replace(",", ".") : ret;
    }

    private String toRow(TableRowColumn trc) {
        FinalizedMonitor[] monitors = trc.getFinalizedMonitors();
        String ret = trc.getExperimentName() + " " + trc.getLabel();
        for (int i = 0; i < monitors.length; ++i) {
            boolean last = i + 1 == monitors.length;
            ret = ret + latexSep + this.getLatexEntry(monitors[i]) + (last ? latexEnd : "");
        }
        return ret;
    }

    public String getLatexEntry(FinalizedMonitor m) {
        return m.getAvg() + "";
    }
}

