/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.commons.experiments.impl;

import java.util.List;
import org.aksw.commons.experiments.FinalizedMonitor;
import org.aksw.commons.experiments.Table;
import org.aksw.commons.experiments.TableFormatter;
import org.aksw.commons.experiments.TableRowColumn;

public class LatexColumnFormatter
implements TableFormatter {
    boolean replaceCommaByPoints = true;
    boolean addNumbersInFront = true;
    public static String latexSep = "\t&\t";
    public static String latexEnd = "\\\\";

    @Override
    public String format(Table table) {
        int length = table.size();
        List<TableRowColumn> tableRowColumns = table.getTableRowColumns();
        String[] rows = new String[length + 1];
        for (int i = 0; i < length + 1; ++i) {
            rows[i] = "";
        }
        for (int a = 0; a < tableRowColumns.size(); ++a) {
            TableRowColumn trc = tableRowColumns.get(a);
            String header = trc.getExperimentName() + " " + trc.getLabel();
            boolean firstColumn = a == 0;
            boolean lastColumn = a + 1 == tableRowColumns.size();
            for (int i = 1; i < length + 1; ++i) {
                boolean firstRow = i == 1;
                rows[0] = rows[0] + (firstColumn && firstRow && this.addNumbersInFront ? latexSep : "");
                rows[0] = rows[0] + (firstRow ? header + latexSep : "");
                int n = i;
                rows[n] = rows[n] + (firstColumn && this.addNumbersInFront ? i + latexSep : "");
                int n2 = i;
                rows[n2] = rows[n2] + this.getLatexEntry(trc.getFinalizedMonitors()[i - 1]) + (lastColumn ? latexSep : latexSep);
            }
        }
        String ret = "";
        for (int i = 0; i < length + 1; ++i) {
            ret = ret + rows[i] + "\n";
        }
        return this.replaceCommaByPoints ? ret.replace(",", ".") : ret;
    }

    public String getLatexEntry(FinalizedMonitor m) {
        return m.getAvg() + " ";
    }
}

