/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.commons.experiments.impl;

import java.text.DecimalFormat;
import org.aksw.commons.experiments.Table;
import org.aksw.commons.experiments.TableFormatter;
import org.aksw.commons.experiments.TableRowColumn;

public class GNUPlotRowFormatter
implements TableFormatter {
    DecimalFormat dfGnuPlotDefault = new DecimalFormat("######0.00####");
    boolean replaceCommaByPoints = true;

    @Override
    public String format(Table table) {
        String ret = "";
        for (TableRowColumn trc : table.getTableRowColumns()) {
            ret = ret + this.toRow(trc) + "\n";
        }
        return this.replaceCommaByPoints ? ret.replace(",", ".") : ret;
    }

    private String toRow(TableRowColumn trc) {
        String ret = trc.getExperimentName() + " " + trc.getLabel();
        for (int i = 0; i < trc.getFinalizedMonitors().length; ++i) {
            boolean last = i + 1 == trc.getFinalizedMonitors().length;
            ret = ret + "\t" + this.dfGnuPlotDefault.format(trc.getFinalizedMonitors()[i].getAvg());
        }
        return ret;
    }
}

