/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.commons.collections;

import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.aksw.commons.collections.Descender;

public class DescenderIterator<T>
implements Iterator<List<T>> {
    private List<Iterator<? extends T>> iterators = new ArrayList<Iterator<? extends T>>();
    private List<T> current = new ArrayList<T>();
    private List<T> resultView;
    private Descender<T> descender;
    private Iterator<T> childIterator = null;
    private boolean canDescend = false;
    private boolean nextCalled = true;
    private boolean finished = false;

    public DescenderIterator(T base, Descender<T> descender) {
        this.descender = descender;
        this.iterators.add(Collections.singleton(base).iterator());
        this.current.add(null);
        this.resultView = Collections.unmodifiableList(this.current);
    }

    public static <T> List<Integer> getIndexesOfEmptySubIterables(List<? extends Iterable<? extends T>> iterables) {
        ArrayList<Integer> result = new ArrayList<Integer>();
        for (int i = 0; i < iterables.size(); ++i) {
            Iterable<? extends T> iterable = iterables.get(i);
            if (!Iterables.isEmpty(iterable)) continue;
            result.add(i);
        }
        return result;
    }

    public void loadChildren() {
        if (this.current.isEmpty()) {
            this.canDescend = false;
            return;
        }
        if (this.childIterator != null) {
            return;
        }
        T item = this.current.get(this.current.size() - 1);
        this.childIterator = this.descender.getDescendCollection(item).iterator();
        this.canDescend = this.childIterator.hasNext();
    }

    public boolean canDescend() {
        this.loadChildren();
        return this.canDescend;
    }

    public void descend() {
        this.loadChildren();
        this.iterators.add(this.childIterator);
        this.current.add(null);
        this.nextCalled = true;
        this.childIterator = null;
    }

    @Override
    public boolean hasNext() {
        this.prepareNext();
        return !this.finished;
    }

    private void prepareNext() {
        if (this.finished || !this.nextCalled) {
            return;
        }
        this.nextCalled = false;
        this.childIterator = null;
        for (int i = this.iterators.size() - 1; i >= 0; --i) {
            Iterator<T> it = this.iterators.get(i);
            if (!it.hasNext()) {
                if (i == 0) {
                    this.finished = true;
                    break;
                }
            } else {
                T item = it.next();
                this.current.set(i, item);
                break;
            }
            this.iterators.remove(i);
            this.current.remove(i);
        }
    }

    @Override
    public List<T> next() {
        this.prepareNext();
        this.nextCalled = true;
        this.childIterator = null;
        return this.resultView;
    }

    @Override
    public void remove() {
        throw new RuntimeException("Operation not supported");
    }
}

